@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.AmiEphemeralBlockDeviceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deviceName Path at which the device is exposed to created instances.
 * @property virtualName Name for the ephemeral device, of the form "ephemeralN" where
 * *N* is a volume number starting from zero.
 */
public data class AmiEphemeralBlockDeviceArgs(
    public val deviceName: Output<String>,
    public val virtualName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.AmiEphemeralBlockDeviceArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.AmiEphemeralBlockDeviceArgs =
        com.pulumi.aws.ec2.inputs.AmiEphemeralBlockDeviceArgs.builder()
            .deviceName(deviceName.applyValue({ args0 -> args0 }))
            .virtualName(virtualName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AmiEphemeralBlockDeviceArgs].
 */
@PulumiTagMarker
public class AmiEphemeralBlockDeviceArgsBuilder internal constructor() {
    private var deviceName: Output<String>? = null

    private var virtualName: Output<String>? = null

    /**
     * @param value Path at which the device is exposed to created instances.
     */
    @JvmName("paakmjyyvftxumss")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value Name for the ephemeral device, of the form "ephemeralN" where
     * *N* is a volume number starting from zero.
     */
    @JvmName("vlnuylgamcqbhnss")
    public suspend fun virtualName(`value`: Output<String>) {
        this.virtualName = value
    }

    /**
     * @param value Path at which the device is exposed to created instances.
     */
    @JvmName("hnsljhtxreahimhb")
    public suspend fun deviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value Name for the ephemeral device, of the form "ephemeralN" where
     * *N* is a volume number starting from zero.
     */
    @JvmName("vfbilwkidcjsgryv")
    public suspend fun virtualName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualName = mapped
    }

    internal fun build(): AmiEphemeralBlockDeviceArgs = AmiEphemeralBlockDeviceArgs(
        deviceName = deviceName ?: throw PulumiNullFieldException("deviceName"),
        virtualName = virtualName ?: throw PulumiNullFieldException("virtualName"),
    )
}
