@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.DefaultNetworkAclEgressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property action The action to take.
 * @property cidrBlock The CIDR block to match. This must be a valid network mask.
 * @property fromPort The from port to match.
 * @property icmpCode The ICMP type code to be used. Default 0.
 * @property icmpType The ICMP type to be used. Default 0.
 * @property ipv6CidrBlock The IPv6 CIDR block.
 * > For more information on ICMP types and codes, see [Internet Control Message Protocol (ICMP) Parameters](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml).
 * @property protocol The protocol to match. If using the -1 'all' protocol, you must specify a from and to port of 0.
 * @property ruleNo The rule number. Used for ordering.
 * @property toPort The to port to match.
 * The following arguments are optional:
 */
public data class DefaultNetworkAclEgressArgs(
    public val action: Output<String>,
    public val cidrBlock: Output<String>? = null,
    public val fromPort: Output<Int>,
    public val icmpCode: Output<Int>? = null,
    public val icmpType: Output<Int>? = null,
    public val ipv6CidrBlock: Output<String>? = null,
    public val protocol: Output<String>,
    public val ruleNo: Output<Int>,
    public val toPort: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.DefaultNetworkAclEgressArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.DefaultNetworkAclEgressArgs =
        com.pulumi.aws.ec2.inputs.DefaultNetworkAclEgressArgs.builder()
            .action(action.applyValue({ args0 -> args0 }))
            .cidrBlock(cidrBlock?.applyValue({ args0 -> args0 }))
            .fromPort(fromPort.applyValue({ args0 -> args0 }))
            .icmpCode(icmpCode?.applyValue({ args0 -> args0 }))
            .icmpType(icmpType?.applyValue({ args0 -> args0 }))
            .ipv6CidrBlock(ipv6CidrBlock?.applyValue({ args0 -> args0 }))
            .protocol(protocol.applyValue({ args0 -> args0 }))
            .ruleNo(ruleNo.applyValue({ args0 -> args0 }))
            .toPort(toPort.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefaultNetworkAclEgressArgs].
 */
@PulumiTagMarker
public class DefaultNetworkAclEgressArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var cidrBlock: Output<String>? = null

    private var fromPort: Output<Int>? = null

    private var icmpCode: Output<Int>? = null

    private var icmpType: Output<Int>? = null

    private var ipv6CidrBlock: Output<String>? = null

    private var protocol: Output<String>? = null

    private var ruleNo: Output<Int>? = null

    private var toPort: Output<Int>? = null

    /**
     * @param value The action to take.
     */
    @JvmName("fnaesmtlpusorxow")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value The CIDR block to match. This must be a valid network mask.
     */
    @JvmName("bkyovlfgiprqrdjg")
    public suspend fun cidrBlock(`value`: Output<String>) {
        this.cidrBlock = value
    }

    /**
     * @param value The from port to match.
     */
    @JvmName("khgggqdbicakoesn")
    public suspend fun fromPort(`value`: Output<Int>) {
        this.fromPort = value
    }

    /**
     * @param value The ICMP type code to be used. Default 0.
     */
    @JvmName("iiqgbhpleuyemxpb")
    public suspend fun icmpCode(`value`: Output<Int>) {
        this.icmpCode = value
    }

    /**
     * @param value The ICMP type to be used. Default 0.
     */
    @JvmName("lomkjcjqiptxfnqk")
    public suspend fun icmpType(`value`: Output<Int>) {
        this.icmpType = value
    }

    /**
     * @param value The IPv6 CIDR block.
     * > For more information on ICMP types and codes, see [Internet Control Message Protocol (ICMP) Parameters](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml).
     */
    @JvmName("vycqbivndiqipvew")
    public suspend fun ipv6CidrBlock(`value`: Output<String>) {
        this.ipv6CidrBlock = value
    }

    /**
     * @param value The protocol to match. If using the -1 'all' protocol, you must specify a from and to port of 0.
     */
    @JvmName("iuyklgkqqnadomlq")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value The rule number. Used for ordering.
     */
    @JvmName("ddkmnudhfmdxixrt")
    public suspend fun ruleNo(`value`: Output<Int>) {
        this.ruleNo = value
    }

    /**
     * @param value The to port to match.
     * The following arguments are optional:
     */
    @JvmName("xpatftycedaiwirp")
    public suspend fun toPort(`value`: Output<Int>) {
        this.toPort = value
    }

    /**
     * @param value The action to take.
     */
    @JvmName("akmklqsvlhaqecmp")
    public suspend fun action(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value The CIDR block to match. This must be a valid network mask.
     */
    @JvmName("bfuptlyhatxixoeq")
    public suspend fun cidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrBlock = mapped
    }

    /**
     * @param value The from port to match.
     */
    @JvmName("plolmxmrpsonkmyq")
    public suspend fun fromPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fromPort = mapped
    }

    /**
     * @param value The ICMP type code to be used. Default 0.
     */
    @JvmName("uoqxeftfdvmprfux")
    public suspend fun icmpCode(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.icmpCode = mapped
    }

    /**
     * @param value The ICMP type to be used. Default 0.
     */
    @JvmName("fpdxncchcxhkwgif")
    public suspend fun icmpType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.icmpType = mapped
    }

    /**
     * @param value The IPv6 CIDR block.
     * > For more information on ICMP types and codes, see [Internet Control Message Protocol (ICMP) Parameters](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml).
     */
    @JvmName("mteewtuxbxdsftyj")
    public suspend fun ipv6CidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6CidrBlock = mapped
    }

    /**
     * @param value The protocol to match. If using the -1 'all' protocol, you must specify a from and to port of 0.
     */
    @JvmName("hlyjxergmmibewui")
    public suspend fun protocol(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The rule number. Used for ordering.
     */
    @JvmName("nmpvkfrckbsvbptv")
    public suspend fun ruleNo(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleNo = mapped
    }

    /**
     * @param value The to port to match.
     * The following arguments are optional:
     */
    @JvmName("tuyenjgpvxoemqes")
    public suspend fun toPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.toPort = mapped
    }

    internal fun build(): DefaultNetworkAclEgressArgs = DefaultNetworkAclEgressArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        cidrBlock = cidrBlock,
        fromPort = fromPort ?: throw PulumiNullFieldException("fromPort"),
        icmpCode = icmpCode,
        icmpType = icmpType,
        ipv6CidrBlock = ipv6CidrBlock,
        protocol = protocol ?: throw PulumiNullFieldException("protocol"),
        ruleNo = ruleNo ?: throw PulumiNullFieldException("ruleNo"),
        toPort = toPort ?: throw PulumiNullFieldException("toPort"),
    )
}
