@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.FleetFleetInstanceSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property instanceIds The IDs of the instances.
 * @property instanceType Instance type.
 * @property lifecycle Indicates if the instance that was launched is a Spot Instance or On-Demand Instance.
 * @property platform The value is `Windows` for Windows instances. Otherwise, the value is blank.
 */
public data class FleetFleetInstanceSetArgs(
    public val instanceIds: Output<List<String>>? = null,
    public val instanceType: Output<String>? = null,
    public val lifecycle: Output<String>? = null,
    public val platform: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.FleetFleetInstanceSetArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.FleetFleetInstanceSetArgs =
        com.pulumi.aws.ec2.inputs.FleetFleetInstanceSetArgs.builder()
            .instanceIds(instanceIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .lifecycle(lifecycle?.applyValue({ args0 -> args0 }))
            .platform(platform?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetFleetInstanceSetArgs].
 */
@PulumiTagMarker
public class FleetFleetInstanceSetArgsBuilder internal constructor() {
    private var instanceIds: Output<List<String>>? = null

    private var instanceType: Output<String>? = null

    private var lifecycle: Output<String>? = null

    private var platform: Output<String>? = null

    /**
     * @param value The IDs of the instances.
     */
    @JvmName("psjbdnonegcngokp")
    public suspend fun instanceIds(`value`: Output<List<String>>) {
        this.instanceIds = value
    }

    @JvmName("styhjreeupdgupkp")
    public suspend fun instanceIds(vararg values: Output<String>) {
        this.instanceIds = Output.all(values.asList())
    }

    /**
     * @param values The IDs of the instances.
     */
    @JvmName("hhpeokwjojdjwmth")
    public suspend fun instanceIds(values: List<Output<String>>) {
        this.instanceIds = Output.all(values)
    }

    /**
     * @param value Instance type.
     */
    @JvmName("dcubulhoqvcuhcme")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Indicates if the instance that was launched is a Spot Instance or On-Demand Instance.
     */
    @JvmName("dcpwytvcwwaqfbqi")
    public suspend fun lifecycle(`value`: Output<String>) {
        this.lifecycle = value
    }

    /**
     * @param value The value is `Windows` for Windows instances. Otherwise, the value is blank.
     */
    @JvmName("awmorkluoaultlol")
    public suspend fun platform(`value`: Output<String>) {
        this.platform = value
    }

    /**
     * @param value The IDs of the instances.
     */
    @JvmName("rxqpgsnpqpdjasqt")
    public suspend fun instanceIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceIds = mapped
    }

    /**
     * @param values The IDs of the instances.
     */
    @JvmName("negwdojlkhevairx")
    public suspend fun instanceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceIds = mapped
    }

    /**
     * @param value Instance type.
     */
    @JvmName("frbpnxjxhnkergoa")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Indicates if the instance that was launched is a Spot Instance or On-Demand Instance.
     */
    @JvmName("ygohxjkaaegeiawr")
    public suspend fun lifecycle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycle = mapped
    }

    /**
     * @param value The value is `Windows` for Windows instances. Otherwise, the value is blank.
     */
    @JvmName("onfigmbwceaiqrjv")
    public suspend fun platform(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platform = mapped
    }

    internal fun build(): FleetFleetInstanceSetArgs = FleetFleetInstanceSetArgs(
        instanceIds = instanceIds,
        instanceType = instanceType,
        lifecycle = lifecycle,
        platform = platform,
    )
}
