@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property launchTemplateSpecification Nested argument containing EC2 Launch Template to use. Defined below.
 * @property overrides Nested argument(s) containing parameters to override the same parameters in the Launch Template. Defined below.
 */
public data class FleetLaunchTemplateConfigArgs(
    public val launchTemplateSpecification:
    Output<FleetLaunchTemplateConfigLaunchTemplateSpecificationArgs>? = null,
    public val overrides: Output<List<FleetLaunchTemplateConfigOverrideArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigArgs =
        com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigArgs.builder()
            .launchTemplateSpecification(
                launchTemplateSpecification?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .overrides(
                overrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FleetLaunchTemplateConfigArgs].
 */
@PulumiTagMarker
public class FleetLaunchTemplateConfigArgsBuilder internal constructor() {
    private var launchTemplateSpecification:
        Output<FleetLaunchTemplateConfigLaunchTemplateSpecificationArgs>? = null

    private var overrides: Output<List<FleetLaunchTemplateConfigOverrideArgs>>? = null

    /**
     * @param value Nested argument containing EC2 Launch Template to use. Defined below.
     */
    @JvmName("dlootwqiehcobpcf")
    public suspend
    fun launchTemplateSpecification(`value`: Output<FleetLaunchTemplateConfigLaunchTemplateSpecificationArgs>) {
        this.launchTemplateSpecification = value
    }

    /**
     * @param value Nested argument(s) containing parameters to override the same parameters in the Launch Template. Defined below.
     */
    @JvmName("etegswiwgetagppo")
    public suspend fun overrides(`value`: Output<List<FleetLaunchTemplateConfigOverrideArgs>>) {
        this.overrides = value
    }

    @JvmName("awioxpdvdwksvwtl")
    public suspend fun overrides(vararg values: Output<FleetLaunchTemplateConfigOverrideArgs>) {
        this.overrides = Output.all(values.asList())
    }

    /**
     * @param values Nested argument(s) containing parameters to override the same parameters in the Launch Template. Defined below.
     */
    @JvmName("qqdpfesejkujilnj")
    public suspend fun overrides(values: List<Output<FleetLaunchTemplateConfigOverrideArgs>>) {
        this.overrides = Output.all(values)
    }

    /**
     * @param value Nested argument containing EC2 Launch Template to use. Defined below.
     */
    @JvmName("eacamtqqvtqnettg")
    public suspend
    fun launchTemplateSpecification(`value`: FleetLaunchTemplateConfigLaunchTemplateSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateSpecification = mapped
    }

    /**
     * @param argument Nested argument containing EC2 Launch Template to use. Defined below.
     */
    @JvmName("xtraimgtsgpkqfgm")
    public suspend
    fun launchTemplateSpecification(argument: suspend FleetLaunchTemplateConfigLaunchTemplateSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = FleetLaunchTemplateConfigLaunchTemplateSpecificationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.launchTemplateSpecification = mapped
    }

    /**
     * @param value Nested argument(s) containing parameters to override the same parameters in the Launch Template. Defined below.
     */
    @JvmName("bfcdnqgeftlqqsgr")
    public suspend fun overrides(`value`: List<FleetLaunchTemplateConfigOverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overrides = mapped
    }

    /**
     * @param argument Nested argument(s) containing parameters to override the same parameters in the Launch Template. Defined below.
     */
    @JvmName("bkvkcpqwuownepfe")
    public suspend
    fun overrides(argument: List<suspend FleetLaunchTemplateConfigOverrideArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FleetLaunchTemplateConfigOverrideArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.overrides = mapped
    }

    /**
     * @param argument Nested argument(s) containing parameters to override the same parameters in the Launch Template. Defined below.
     */
    @JvmName("bvxqjyjoghamymuk")
    public suspend fun overrides(
        vararg
        argument: suspend FleetLaunchTemplateConfigOverrideArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FleetLaunchTemplateConfigOverrideArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.overrides = mapped
    }

    /**
     * @param argument Nested argument(s) containing parameters to override the same parameters in the Launch Template. Defined below.
     */
    @JvmName("sqwjnixmklqxgwoo")
    public suspend
    fun overrides(argument: suspend FleetLaunchTemplateConfigOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FleetLaunchTemplateConfigOverrideArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.overrides = mapped
    }

    /**
     * @param values Nested argument(s) containing parameters to override the same parameters in the Launch Template. Defined below.
     */
    @JvmName("bdqhmjxpsnyhpiyw")
    public suspend fun overrides(vararg values: FleetLaunchTemplateConfigOverrideArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.overrides = mapped
    }

    internal fun build(): FleetLaunchTemplateConfigArgs = FleetLaunchTemplateConfigArgs(
        launchTemplateSpecification = launchTemplateSpecification,
        overrides = overrides,
    )
}
