@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigLaunchTemplateSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property launchTemplateId The ID of the launch template.
 * @property launchTemplateName The name of the launch template.
 * @property version The launch template version number, `$Latest`, or `$Default.`
 */
public data class FleetLaunchTemplateConfigLaunchTemplateSpecificationArgs(
    public val launchTemplateId: Output<String>? = null,
    public val launchTemplateName: Output<String>? = null,
    public val version: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigLaunchTemplateSpecificationArgs> {
    override fun toJava():
        com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigLaunchTemplateSpecificationArgs =
        com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigLaunchTemplateSpecificationArgs.builder()
            .launchTemplateId(launchTemplateId?.applyValue({ args0 -> args0 }))
            .launchTemplateName(launchTemplateName?.applyValue({ args0 -> args0 }))
            .version(version.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetLaunchTemplateConfigLaunchTemplateSpecificationArgs].
 */
@PulumiTagMarker
public class FleetLaunchTemplateConfigLaunchTemplateSpecificationArgsBuilder internal constructor() {
    private var launchTemplateId: Output<String>? = null

    private var launchTemplateName: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value The ID of the launch template.
     */
    @JvmName("vhjlvdkuigsspnwy")
    public suspend fun launchTemplateId(`value`: Output<String>) {
        this.launchTemplateId = value
    }

    /**
     * @param value The name of the launch template.
     */
    @JvmName("yabwosictmdvmunc")
    public suspend fun launchTemplateName(`value`: Output<String>) {
        this.launchTemplateName = value
    }

    /**
     * @param value The launch template version number, `$Latest`, or `$Default.`
     */
    @JvmName("jntievcmmvafdxwq")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The ID of the launch template.
     */
    @JvmName("jyokyiaawdbphmeg")
    public suspend fun launchTemplateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateId = mapped
    }

    /**
     * @param value The name of the launch template.
     */
    @JvmName("oklomnmcfkisebrb")
    public suspend fun launchTemplateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateName = mapped
    }

    /**
     * @param value The launch template version number, `$Latest`, or `$Default.`
     */
    @JvmName("lyroduaanubwydnx")
    public suspend fun version(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): FleetLaunchTemplateConfigLaunchTemplateSpecificationArgs =
        FleetLaunchTemplateConfigLaunchTemplateSpecificationArgs(
            launchTemplateId = launchTemplateId,
            launchTemplateName = launchTemplateName,
            version = version ?: throw PulumiNullFieldException("version"),
        )
}
