@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property availabilityZone Availability Zone in which to launch the instances.
 * @property instanceRequirements Override the instance type in the Launch Template with instance types that satisfy the requirements.
 * @property instanceType Instance type.
 * @property maxPrice Maximum price per unit hour that you are willing to pay for a Spot Instance.
 * @property priority Priority for the launch template override. If `on_demand_options` `allocation_strategy` is set to `prioritized`, EC2 Fleet uses priority to determine which launch template override to use first in fulfilling On-Demand capacity. The highest priority is launched first. The lower the number, the higher the priority. If no number is set, the launch template override has the lowest priority. Valid values are whole numbers starting at 0.
 * @property subnetId ID of the subnet in which to launch the instances.
 * @property weightedCapacity Number of units provided by the specified instance type.
 */
public data class FleetLaunchTemplateConfigOverrideArgs(
    public val availabilityZone: Output<String>? = null,
    public val instanceRequirements:
    Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsArgs>? = null,
    public val instanceType: Output<String>? = null,
    public val maxPrice: Output<String>? = null,
    public val priority: Output<Double>? = null,
    public val subnetId: Output<String>? = null,
    public val weightedCapacity: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideArgs =
        com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideArgs.builder()
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .instanceRequirements(
                instanceRequirements?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .maxPrice(maxPrice?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .weightedCapacity(weightedCapacity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetLaunchTemplateConfigOverrideArgs].
 */
@PulumiTagMarker
public class FleetLaunchTemplateConfigOverrideArgsBuilder internal constructor() {
    private var availabilityZone: Output<String>? = null

    private var instanceRequirements:
        Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsArgs>? = null

    private var instanceType: Output<String>? = null

    private var maxPrice: Output<String>? = null

    private var priority: Output<Double>? = null

    private var subnetId: Output<String>? = null

    private var weightedCapacity: Output<Double>? = null

    /**
     * @param value Availability Zone in which to launch the instances.
     */
    @JvmName("pbhtkqkocdetjjod")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value Override the instance type in the Launch Template with instance types that satisfy the requirements.
     */
    @JvmName("msfntkhbyeriylnc")
    public suspend
    fun instanceRequirements(`value`: Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsArgs>) {
        this.instanceRequirements = value
    }

    /**
     * @param value Instance type.
     */
    @JvmName("yxbrfmhyuewmphhn")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Maximum price per unit hour that you are willing to pay for a Spot Instance.
     */
    @JvmName("chvukduhoklakosb")
    public suspend fun maxPrice(`value`: Output<String>) {
        this.maxPrice = value
    }

    /**
     * @param value Priority for the launch template override. If `on_demand_options` `allocation_strategy` is set to `prioritized`, EC2 Fleet uses priority to determine which launch template override to use first in fulfilling On-Demand capacity. The highest priority is launched first. The lower the number, the higher the priority. If no number is set, the launch template override has the lowest priority. Valid values are whole numbers starting at 0.
     */
    @JvmName("ogepumfdiedulhpa")
    public suspend fun priority(`value`: Output<Double>) {
        this.priority = value
    }

    /**
     * @param value ID of the subnet in which to launch the instances.
     */
    @JvmName("ufocjactoqflhivb")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Number of units provided by the specified instance type.
     */
    @JvmName("alwpryvefqnvkcxc")
    public suspend fun weightedCapacity(`value`: Output<Double>) {
        this.weightedCapacity = value
    }

    /**
     * @param value Availability Zone in which to launch the instances.
     */
    @JvmName("kmotwoxwjfoveflq")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value Override the instance type in the Launch Template with instance types that satisfy the requirements.
     */
    @JvmName("miajkycfmcthamqa")
    public suspend
    fun instanceRequirements(`value`: FleetLaunchTemplateConfigOverrideInstanceRequirementsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceRequirements = mapped
    }

    /**
     * @param argument Override the instance type in the Launch Template with instance types that satisfy the requirements.
     */
    @JvmName("xxeavdfhjgkqiowb")
    public suspend
    fun instanceRequirements(argument: suspend FleetLaunchTemplateConfigOverrideInstanceRequirementsArgsBuilder.() -> Unit) {
        val toBeMapped =
            FleetLaunchTemplateConfigOverrideInstanceRequirementsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.instanceRequirements = mapped
    }

    /**
     * @param value Instance type.
     */
    @JvmName("qrklvcyxgyrgwhrg")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Maximum price per unit hour that you are willing to pay for a Spot Instance.
     */
    @JvmName("frbvruogcmngpctn")
    public suspend fun maxPrice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxPrice = mapped
    }

    /**
     * @param value Priority for the launch template override. If `on_demand_options` `allocation_strategy` is set to `prioritized`, EC2 Fleet uses priority to determine which launch template override to use first in fulfilling On-Demand capacity. The highest priority is launched first. The lower the number, the higher the priority. If no number is set, the launch template override has the lowest priority. Valid values are whole numbers starting at 0.
     */
    @JvmName("sknrycsdkhpkgiby")
    public suspend fun priority(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value ID of the subnet in which to launch the instances.
     */
    @JvmName("qfuecbnoqjbkbxgq")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value Number of units provided by the specified instance type.
     */
    @JvmName("mbxmlpkvfmcvhjwk")
    public suspend fun weightedCapacity(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weightedCapacity = mapped
    }

    internal fun build(): FleetLaunchTemplateConfigOverrideArgs =
        FleetLaunchTemplateConfigOverrideArgs(
            availabilityZone = availabilityZone,
            instanceRequirements = instanceRequirements,
            instanceType = instanceType,
            maxPrice = maxPrice,
            priority = priority,
            subnetId = subnetId,
            weightedCapacity = weightedCapacity,
        )
}
