@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property max The maximum number of vCPUs. To specify no maximum limit, omit this parameter.
 * @property min The minimum number of vCPUs. To specify no minimum limit, specify `0`.
 */
public data class
FleetLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgs(
    public val max: Output<Int>? = null,
    public val min: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgs> {
    override fun toJava():
        com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgs =
        com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgs.builder()
            .max(max?.applyValue({ args0 -> args0 }))
            .min(min?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgs].
 */
@PulumiTagMarker
public class
FleetLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgsBuilder
internal constructor() {
    private var max: Output<Int>? = null

    private var min: Output<Int>? = null

    /**
     * @param value The maximum number of vCPUs. To specify no maximum limit, omit this parameter.
     */
    @JvmName("afnxawnxomnuiqci")
    public suspend fun max(`value`: Output<Int>) {
        this.max = value
    }

    /**
     * @param value The minimum number of vCPUs. To specify no minimum limit, specify `0`.
     */
    @JvmName("ijyevchefpdselot")
    public suspend fun min(`value`: Output<Int>) {
        this.min = value
    }

    /**
     * @param value The maximum number of vCPUs. To specify no maximum limit, omit this parameter.
     */
    @JvmName("qouvjfvjfmhfywdi")
    public suspend fun max(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.max = mapped
    }

    /**
     * @param value The minimum number of vCPUs. To specify no minimum limit, specify `0`.
     */
    @JvmName("hnnhvmfxqccgihlu")
    public suspend fun min(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.min = mapped
    }

    internal fun build():
        FleetLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgs =
        FleetLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgs(
            max = max,
            min = min,
        )
}
