@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideInstanceRequirementsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property acceleratorCount Block describing the minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips). Default is no minimum or maximum limits.
 * @property acceleratorManufacturers List of accelerator manufacturer names. Default is any manufacturer.
 * @property acceleratorNames List of accelerator names. Default is any acclerator.
 * @property acceleratorTotalMemoryMib Block describing the minimum and maximum total memory of the accelerators. Default is no minimum or maximum.
 * @property acceleratorTypes The accelerator types that must be on the instance type. Default is any accelerator type.
 * @property allowedInstanceTypes The instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes. You can use strings with one or more wild cards,represented by an asterisk (\*). The following are examples: `c5*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are excluding all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is no excluded instance types. Default is any instance type.
 * If you specify `AllowedInstanceTypes`, you can't specify `ExcludedInstanceTypes`.
 * @property bareMetal Indicate whether bare metal instace types should be `included`, `excluded`, or `required`. Default is `excluded`.
 * @property baselineEbsBandwidthMbps Block describing the minimum and maximum baseline EBS bandwidth, in Mbps. Default is no minimum or maximum.
 * @property burstablePerformance Indicates whether burstable performance T instance types are `included`, `excluded`, or `required`. Default is `excluded`.
 * @property cpuManufacturers The CPU manufacturers to include. Default is any manufacturer.
 * > **NOTE:** Don't confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
 * @property excludedInstanceTypes The instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (\*). The following are examples: `c5*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are excluding all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is no excluded instance types.
 * If you specify `AllowedInstanceTypes`, you can't specify `ExcludedInstanceTypes`.
 * @property instanceGenerations Indicates whether current or previous generation instance types are included. The current generation instance types are recommended for use. Valid values are `current` and `previous`. Default is `current` and `previous` generation instance types.
 * @property localStorage Indicate whether instance types with local storage volumes are `included`, `excluded`, or `required`. Default is `included`.
 * @property localStorageTypes List of local storage type names. Valid values are `hdd` and `ssd`. Default any storage type.
 * @property memoryGibPerVcpu Block describing the minimum and maximum amount of memory (GiB) per vCPU. Default is no minimum or maximum.
 * @property memoryMib The minimum and maximum amount of memory per vCPU, in GiB. Default is no minimum or maximum limits.
 * @property networkBandwidthGbps The minimum and maximum amount of network bandwidth, in gigabits per second (Gbps). Default is No minimum or maximum.
 * @property networkInterfaceCount Block describing the minimum and maximum number of network interfaces. Default is no minimum or maximum.
 * @property onDemandMaxPricePercentageOverLowestPrice The price protection threshold for On-Demand Instances. This is the maximum you’ll pay for an On-Demand Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Default is 20.
 * If you set `target_capacity_unit_type` to `vcpu` or `memory-mib`, the price protection threshold is applied based on the per-vCPU or per-memory price instead of the per-instance price.
 * @property requireHibernateSupport Indicate whether instance types must support On-Demand Instance Hibernation, either `true` or `false`. Default is `false`.
 * @property spotMaxPricePercentageOverLowestPrice The price protection threshold for Spot Instances. This is the maximum you’ll pay for a Spot Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Default is 100.
 * If you set DesiredCapacityType to vcpu or memory-mib, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price.
 * @property totalLocalStorageGb Block describing the minimum and maximum total local storage (GB). Default is no minimum or maximum.
 * @property vcpuCount Block describing the minimum and maximum number of vCPUs. Default is no maximum.
 */
public data class FleetLaunchTemplateConfigOverrideInstanceRequirementsArgs(
    public val acceleratorCount:
    Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorCountArgs>? = null,
    public val acceleratorManufacturers: Output<List<String>>? = null,
    public val acceleratorNames: Output<List<String>>? = null,
    public val acceleratorTotalMemoryMib:
    Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgs>? =
        null,
    public val acceleratorTypes: Output<List<String>>? = null,
    public val allowedInstanceTypes: Output<List<String>>? = null,
    public val bareMetal: Output<String>? = null,
    public val baselineEbsBandwidthMbps:
    Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgs>? =
        null,
    public val burstablePerformance: Output<String>? = null,
    public val cpuManufacturers: Output<List<String>>? = null,
    public val excludedInstanceTypes: Output<List<String>>? = null,
    public val instanceGenerations: Output<List<String>>? = null,
    public val localStorage: Output<String>? = null,
    public val localStorageTypes: Output<List<String>>? = null,
    public val memoryGibPerVcpu:
    Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpuArgs>? = null,
    public val memoryMib: Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryMibArgs>,
    public val networkBandwidthGbps:
    Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbpsArgs>? = null,
    public val networkInterfaceCount:
    Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsNetworkInterfaceCountArgs>? =
        null,
    public val onDemandMaxPricePercentageOverLowestPrice: Output<Int>? = null,
    public val requireHibernateSupport: Output<Boolean>? = null,
    public val spotMaxPricePercentageOverLowestPrice: Output<Int>? = null,
    public val totalLocalStorageGb:
    Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsTotalLocalStorageGbArgs>? = null,
    public val vcpuCount: Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsVcpuCountArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideInstanceRequirementsArgs> {
    override fun toJava():
        com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideInstanceRequirementsArgs =
        com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideInstanceRequirementsArgs.builder()
            .acceleratorCount(acceleratorCount?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .acceleratorManufacturers(
                acceleratorManufacturers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .acceleratorNames(acceleratorNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .acceleratorTotalMemoryMib(
                acceleratorTotalMemoryMib?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .acceleratorTypes(acceleratorTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedInstanceTypes(allowedInstanceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .bareMetal(bareMetal?.applyValue({ args0 -> args0 }))
            .baselineEbsBandwidthMbps(
                baselineEbsBandwidthMbps?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .burstablePerformance(burstablePerformance?.applyValue({ args0 -> args0 }))
            .cpuManufacturers(cpuManufacturers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .excludedInstanceTypes(excludedInstanceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceGenerations(instanceGenerations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .localStorage(localStorage?.applyValue({ args0 -> args0 }))
            .localStorageTypes(localStorageTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .memoryGibPerVcpu(memoryGibPerVcpu?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .memoryMib(memoryMib.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .networkBandwidthGbps(
                networkBandwidthGbps?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .networkInterfaceCount(
                networkInterfaceCount?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .onDemandMaxPricePercentageOverLowestPrice(
                onDemandMaxPricePercentageOverLowestPrice?.applyValue({ args0 ->
                    args0
                }),
            )
            .requireHibernateSupport(requireHibernateSupport?.applyValue({ args0 -> args0 }))
            .spotMaxPricePercentageOverLowestPrice(
                spotMaxPricePercentageOverLowestPrice?.applyValue({ args0 ->
                    args0
                }),
            )
            .totalLocalStorageGb(
                totalLocalStorageGb?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .vcpuCount(vcpuCount.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FleetLaunchTemplateConfigOverrideInstanceRequirementsArgs].
 */
@PulumiTagMarker
public class FleetLaunchTemplateConfigOverrideInstanceRequirementsArgsBuilder internal constructor() {
    private var acceleratorCount:
        Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorCountArgs>? = null

    private var acceleratorManufacturers: Output<List<String>>? = null

    private var acceleratorNames: Output<List<String>>? = null

    private var acceleratorTotalMemoryMib:
        Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgs>? =
        null

    private var acceleratorTypes: Output<List<String>>? = null

    private var allowedInstanceTypes: Output<List<String>>? = null

    private var bareMetal: Output<String>? = null

    private var baselineEbsBandwidthMbps:
        Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgs>? =
        null

    private var burstablePerformance: Output<String>? = null

    private var cpuManufacturers: Output<List<String>>? = null

    private var excludedInstanceTypes: Output<List<String>>? = null

    private var instanceGenerations: Output<List<String>>? = null

    private var localStorage: Output<String>? = null

    private var localStorageTypes: Output<List<String>>? = null

    private var memoryGibPerVcpu:
        Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpuArgs>? = null

    private var memoryMib: Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryMibArgs>? =
        null

    private var networkBandwidthGbps:
        Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbpsArgs>? = null

    private var networkInterfaceCount:
        Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsNetworkInterfaceCountArgs>? = null

    private var onDemandMaxPricePercentageOverLowestPrice: Output<Int>? = null

    private var requireHibernateSupport: Output<Boolean>? = null

    private var spotMaxPricePercentageOverLowestPrice: Output<Int>? = null

    private var totalLocalStorageGb:
        Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsTotalLocalStorageGbArgs>? = null

    private var vcpuCount: Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsVcpuCountArgs>? =
        null

    /**
     * @param value Block describing the minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips). Default is no minimum or maximum limits.
     */
    @JvmName("najjiglnnlprxcup")
    public suspend
    fun acceleratorCount(`value`: Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorCountArgs>) {
        this.acceleratorCount = value
    }

    /**
     * @param value List of accelerator manufacturer names. Default is any manufacturer.
     */
    @JvmName("kuqkalgxfrimiyoq")
    public suspend fun acceleratorManufacturers(`value`: Output<List<String>>) {
        this.acceleratorManufacturers = value
    }

    @JvmName("slakhomiycykfgxq")
    public suspend fun acceleratorManufacturers(vararg values: Output<String>) {
        this.acceleratorManufacturers = Output.all(values.asList())
    }

    /**
     * @param values List of accelerator manufacturer names. Default is any manufacturer.
     */
    @JvmName("qgnwymacvtkpijuo")
    public suspend fun acceleratorManufacturers(values: List<Output<String>>) {
        this.acceleratorManufacturers = Output.all(values)
    }

    /**
     * @param value List of accelerator names. Default is any acclerator.
     */
    @JvmName("xxjteerpstkmrttd")
    public suspend fun acceleratorNames(`value`: Output<List<String>>) {
        this.acceleratorNames = value
    }

    @JvmName("asbwuvmvemvuyxec")
    public suspend fun acceleratorNames(vararg values: Output<String>) {
        this.acceleratorNames = Output.all(values.asList())
    }

    /**
     * @param values List of accelerator names. Default is any acclerator.
     */
    @JvmName("ukikacrdswdnwjhq")
    public suspend fun acceleratorNames(values: List<Output<String>>) {
        this.acceleratorNames = Output.all(values)
    }

    /**
     * @param value Block describing the minimum and maximum total memory of the accelerators. Default is no minimum or maximum.
     */
    @JvmName("hwfemiigbckbjuyk")
    public suspend
    fun acceleratorTotalMemoryMib(`value`: Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgs>) {
        this.acceleratorTotalMemoryMib = value
    }

    /**
     * @param value The accelerator types that must be on the instance type. Default is any accelerator type.
     */
    @JvmName("tlnncwnptabvxabf")
    public suspend fun acceleratorTypes(`value`: Output<List<String>>) {
        this.acceleratorTypes = value
    }

    @JvmName("ajdpdljondllvdfv")
    public suspend fun acceleratorTypes(vararg values: Output<String>) {
        this.acceleratorTypes = Output.all(values.asList())
    }

    /**
     * @param values The accelerator types that must be on the instance type. Default is any accelerator type.
     */
    @JvmName("nvvijwqbjlwupwux")
    public suspend fun acceleratorTypes(values: List<Output<String>>) {
        this.acceleratorTypes = Output.all(values)
    }

    /**
     * @param value The instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes. You can use strings with one or more wild cards,represented by an asterisk (\*). The following are examples: `c5*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are excluding all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is no excluded instance types. Default is any instance type.
     * If you specify `AllowedInstanceTypes`, you can't specify `ExcludedInstanceTypes`.
     */
    @JvmName("rljgjcjwnsrtiwsx")
    public suspend fun allowedInstanceTypes(`value`: Output<List<String>>) {
        this.allowedInstanceTypes = value
    }

    @JvmName("eoslrgnyhrcqnaap")
    public suspend fun allowedInstanceTypes(vararg values: Output<String>) {
        this.allowedInstanceTypes = Output.all(values.asList())
    }

    /**
     * @param values The instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes. You can use strings with one or more wild cards,represented by an asterisk (\*). The following are examples: `c5*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are excluding all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is no excluded instance types. Default is any instance type.
     * If you specify `AllowedInstanceTypes`, you can't specify `ExcludedInstanceTypes`.
     */
    @JvmName("kulaoevniwujifcu")
    public suspend fun allowedInstanceTypes(values: List<Output<String>>) {
        this.allowedInstanceTypes = Output.all(values)
    }

    /**
     * @param value Indicate whether bare metal instace types should be `included`, `excluded`, or `required`. Default is `excluded`.
     */
    @JvmName("txftlrgkxspmgfmt")
    public suspend fun bareMetal(`value`: Output<String>) {
        this.bareMetal = value
    }

    /**
     * @param value Block describing the minimum and maximum baseline EBS bandwidth, in Mbps. Default is no minimum or maximum.
     */
    @JvmName("afxwbubkmskrpuhi")
    public suspend
    fun baselineEbsBandwidthMbps(`value`: Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgs>) {
        this.baselineEbsBandwidthMbps = value
    }

    /**
     * @param value Indicates whether burstable performance T instance types are `included`, `excluded`, or `required`. Default is `excluded`.
     */
    @JvmName("ygqhgjhurxqnwyuh")
    public suspend fun burstablePerformance(`value`: Output<String>) {
        this.burstablePerformance = value
    }

    /**
     * @param value The CPU manufacturers to include. Default is any manufacturer.
     * > **NOTE:** Don't confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
     */
    @JvmName("twquafdjlyijeynl")
    public suspend fun cpuManufacturers(`value`: Output<List<String>>) {
        this.cpuManufacturers = value
    }

    @JvmName("lnpanyhoiwbyjxcl")
    public suspend fun cpuManufacturers(vararg values: Output<String>) {
        this.cpuManufacturers = Output.all(values.asList())
    }

    /**
     * @param values The CPU manufacturers to include. Default is any manufacturer.
     * > **NOTE:** Don't confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
     */
    @JvmName("gmcguysbwfnvqdgw")
    public suspend fun cpuManufacturers(values: List<Output<String>>) {
        this.cpuManufacturers = Output.all(values)
    }

    /**
     * @param value The instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (\*). The following are examples: `c5*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are excluding all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is no excluded instance types.
     * If you specify `AllowedInstanceTypes`, you can't specify `ExcludedInstanceTypes`.
     */
    @JvmName("dfqjjwtiolfrursh")
    public suspend fun excludedInstanceTypes(`value`: Output<List<String>>) {
        this.excludedInstanceTypes = value
    }

    @JvmName("vjdojubxiyblqwla")
    public suspend fun excludedInstanceTypes(vararg values: Output<String>) {
        this.excludedInstanceTypes = Output.all(values.asList())
    }

    /**
     * @param values The instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (\*). The following are examples: `c5*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are excluding all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is no excluded instance types.
     * If you specify `AllowedInstanceTypes`, you can't specify `ExcludedInstanceTypes`.
     */
    @JvmName("gvuckeckypdwlsmp")
    public suspend fun excludedInstanceTypes(values: List<Output<String>>) {
        this.excludedInstanceTypes = Output.all(values)
    }

    /**
     * @param value Indicates whether current or previous generation instance types are included. The current generation instance types are recommended for use. Valid values are `current` and `previous`. Default is `current` and `previous` generation instance types.
     */
    @JvmName("imdxmfqnejxtbjyt")
    public suspend fun instanceGenerations(`value`: Output<List<String>>) {
        this.instanceGenerations = value
    }

    @JvmName("wsmleesulwdusoxh")
    public suspend fun instanceGenerations(vararg values: Output<String>) {
        this.instanceGenerations = Output.all(values.asList())
    }

    /**
     * @param values Indicates whether current or previous generation instance types are included. The current generation instance types are recommended for use. Valid values are `current` and `previous`. Default is `current` and `previous` generation instance types.
     */
    @JvmName("ledjdesvwlxkcoql")
    public suspend fun instanceGenerations(values: List<Output<String>>) {
        this.instanceGenerations = Output.all(values)
    }

    /**
     * @param value Indicate whether instance types with local storage volumes are `included`, `excluded`, or `required`. Default is `included`.
     */
    @JvmName("gxcksheyancmpdjd")
    public suspend fun localStorage(`value`: Output<String>) {
        this.localStorage = value
    }

    /**
     * @param value List of local storage type names. Valid values are `hdd` and `ssd`. Default any storage type.
     */
    @JvmName("lfgbfvjexittqbtg")
    public suspend fun localStorageTypes(`value`: Output<List<String>>) {
        this.localStorageTypes = value
    }

    @JvmName("ybctruobtstrvapq")
    public suspend fun localStorageTypes(vararg values: Output<String>) {
        this.localStorageTypes = Output.all(values.asList())
    }

    /**
     * @param values List of local storage type names. Valid values are `hdd` and `ssd`. Default any storage type.
     */
    @JvmName("buibhpfuvacgyxso")
    public suspend fun localStorageTypes(values: List<Output<String>>) {
        this.localStorageTypes = Output.all(values)
    }

    /**
     * @param value Block describing the minimum and maximum amount of memory (GiB) per vCPU. Default is no minimum or maximum.
     */
    @JvmName("ihcvfvrhvpklhhav")
    public suspend
    fun memoryGibPerVcpu(`value`: Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpuArgs>) {
        this.memoryGibPerVcpu = value
    }

    /**
     * @param value The minimum and maximum amount of memory per vCPU, in GiB. Default is no minimum or maximum limits.
     */
    @JvmName("wsbgeadcemxlwbwc")
    public suspend
    fun memoryMib(`value`: Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryMibArgs>) {
        this.memoryMib = value
    }

    /**
     * @param value The minimum and maximum amount of network bandwidth, in gigabits per second (Gbps). Default is No minimum or maximum.
     */
    @JvmName("eraxposwrufkkscr")
    public suspend
    fun networkBandwidthGbps(`value`: Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbpsArgs>) {
        this.networkBandwidthGbps = value
    }

    /**
     * @param value Block describing the minimum and maximum number of network interfaces. Default is no minimum or maximum.
     */
    @JvmName("yulskvcplixykxsv")
    public suspend
    fun networkInterfaceCount(`value`: Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsNetworkInterfaceCountArgs>) {
        this.networkInterfaceCount = value
    }

    /**
     * @param value The price protection threshold for On-Demand Instances. This is the maximum you’ll pay for an On-Demand Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Default is 20.
     * If you set `target_capacity_unit_type` to `vcpu` or `memory-mib`, the price protection threshold is applied based on the per-vCPU or per-memory price instead of the per-instance price.
     */
    @JvmName("dnytsncbphgcjpyw")
    public suspend fun onDemandMaxPricePercentageOverLowestPrice(`value`: Output<Int>) {
        this.onDemandMaxPricePercentageOverLowestPrice = value
    }

    /**
     * @param value Indicate whether instance types must support On-Demand Instance Hibernation, either `true` or `false`. Default is `false`.
     */
    @JvmName("dauamputplfnogpu")
    public suspend fun requireHibernateSupport(`value`: Output<Boolean>) {
        this.requireHibernateSupport = value
    }

    /**
     * @param value The price protection threshold for Spot Instances. This is the maximum you’ll pay for a Spot Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Default is 100.
     * If you set DesiredCapacityType to vcpu or memory-mib, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price.
     */
    @JvmName("qaqrsgljhmbhingd")
    public suspend fun spotMaxPricePercentageOverLowestPrice(`value`: Output<Int>) {
        this.spotMaxPricePercentageOverLowestPrice = value
    }

    /**
     * @param value Block describing the minimum and maximum total local storage (GB). Default is no minimum or maximum.
     */
    @JvmName("mihjspcpgtxmgfqa")
    public suspend
    fun totalLocalStorageGb(`value`: Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsTotalLocalStorageGbArgs>) {
        this.totalLocalStorageGb = value
    }

    /**
     * @param value Block describing the minimum and maximum number of vCPUs. Default is no maximum.
     */
    @JvmName("tcmywaeoysafijsf")
    public suspend
    fun vcpuCount(`value`: Output<FleetLaunchTemplateConfigOverrideInstanceRequirementsVcpuCountArgs>) {
        this.vcpuCount = value
    }

    /**
     * @param value Block describing the minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips). Default is no minimum or maximum limits.
     */
    @JvmName("uwdeewlqgrmaxcdi")
    public suspend
    fun acceleratorCount(`value`: FleetLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorCountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorCount = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips). Default is no minimum or maximum limits.
     */
    @JvmName("jrtptxxvhnwojdpo")
    public suspend
    fun acceleratorCount(argument: suspend FleetLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorCountArgsBuilder.() -> Unit) {
        val toBeMapped =
            FleetLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorCountArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.acceleratorCount = mapped
    }

    /**
     * @param value List of accelerator manufacturer names. Default is any manufacturer.
     */
    @JvmName("esfwwuqyfprmjcjh")
    public suspend fun acceleratorManufacturers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorManufacturers = mapped
    }

    /**
     * @param values List of accelerator manufacturer names. Default is any manufacturer.
     */
    @JvmName("eaxpxegeesyfkapj")
    public suspend fun acceleratorManufacturers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acceleratorManufacturers = mapped
    }

    /**
     * @param value List of accelerator names. Default is any acclerator.
     */
    @JvmName("ojlfmxqyhgsucyrc")
    public suspend fun acceleratorNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorNames = mapped
    }

    /**
     * @param values List of accelerator names. Default is any acclerator.
     */
    @JvmName("abglhljxralpblid")
    public suspend fun acceleratorNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acceleratorNames = mapped
    }

    /**
     * @param value Block describing the minimum and maximum total memory of the accelerators. Default is no minimum or maximum.
     */
    @JvmName("fiooaynxskuvjsil")
    public suspend
    fun acceleratorTotalMemoryMib(`value`: FleetLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorTotalMemoryMib = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum total memory of the accelerators. Default is no minimum or maximum.
     */
    @JvmName("tmeigxlyjninulqy")
    public suspend
    fun acceleratorTotalMemoryMib(argument: suspend FleetLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgsBuilder.() -> Unit) {
        val toBeMapped =
            FleetLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.acceleratorTotalMemoryMib = mapped
    }

    /**
     * @param value The accelerator types that must be on the instance type. Default is any accelerator type.
     */
    @JvmName("fnkidirymhjdxsxo")
    public suspend fun acceleratorTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorTypes = mapped
    }

    /**
     * @param values The accelerator types that must be on the instance type. Default is any accelerator type.
     */
    @JvmName("qnyiohvqfrehjpgs")
    public suspend fun acceleratorTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acceleratorTypes = mapped
    }

    /**
     * @param value The instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes. You can use strings with one or more wild cards,represented by an asterisk (\*). The following are examples: `c5*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are excluding all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is no excluded instance types. Default is any instance type.
     * If you specify `AllowedInstanceTypes`, you can't specify `ExcludedInstanceTypes`.
     */
    @JvmName("nspntxusovixvcoc")
    public suspend fun allowedInstanceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedInstanceTypes = mapped
    }

    /**
     * @param values The instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes. You can use strings with one or more wild cards,represented by an asterisk (\*). The following are examples: `c5*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are excluding all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is no excluded instance types. Default is any instance type.
     * If you specify `AllowedInstanceTypes`, you can't specify `ExcludedInstanceTypes`.
     */
    @JvmName("ldnfsnofjnsmxelf")
    public suspend fun allowedInstanceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedInstanceTypes = mapped
    }

    /**
     * @param value Indicate whether bare metal instace types should be `included`, `excluded`, or `required`. Default is `excluded`.
     */
    @JvmName("yijvcgqjofknring")
    public suspend fun bareMetal(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bareMetal = mapped
    }

    /**
     * @param value Block describing the minimum and maximum baseline EBS bandwidth, in Mbps. Default is no minimum or maximum.
     */
    @JvmName("ulreibnnosfxckon")
    public suspend
    fun baselineEbsBandwidthMbps(`value`: FleetLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baselineEbsBandwidthMbps = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum baseline EBS bandwidth, in Mbps. Default is no minimum or maximum.
     */
    @JvmName("nittfsrhhxspvfgm")
    public suspend
    fun baselineEbsBandwidthMbps(argument: suspend FleetLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgsBuilder.() -> Unit) {
        val toBeMapped =
            FleetLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.baselineEbsBandwidthMbps = mapped
    }

    /**
     * @param value Indicates whether burstable performance T instance types are `included`, `excluded`, or `required`. Default is `excluded`.
     */
    @JvmName("fanotqiipggyvtjx")
    public suspend fun burstablePerformance(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.burstablePerformance = mapped
    }

    /**
     * @param value The CPU manufacturers to include. Default is any manufacturer.
     * > **NOTE:** Don't confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
     */
    @JvmName("qxsabsxyobbrymop")
    public suspend fun cpuManufacturers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuManufacturers = mapped
    }

    /**
     * @param values The CPU manufacturers to include. Default is any manufacturer.
     * > **NOTE:** Don't confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
     */
    @JvmName("busiasqeltfsfigg")
    public suspend fun cpuManufacturers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cpuManufacturers = mapped
    }

    /**
     * @param value The instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (\*). The following are examples: `c5*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are excluding all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is no excluded instance types.
     * If you specify `AllowedInstanceTypes`, you can't specify `ExcludedInstanceTypes`.
     */
    @JvmName("wxmqyvprlnwbwwdt")
    public suspend fun excludedInstanceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedInstanceTypes = mapped
    }

    /**
     * @param values The instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (\*). The following are examples: `c5*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are excluding all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is no excluded instance types.
     * If you specify `AllowedInstanceTypes`, you can't specify `ExcludedInstanceTypes`.
     */
    @JvmName("jhnccvfwyxloaqge")
    public suspend fun excludedInstanceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedInstanceTypes = mapped
    }

    /**
     * @param value Indicates whether current or previous generation instance types are included. The current generation instance types are recommended for use. Valid values are `current` and `previous`. Default is `current` and `previous` generation instance types.
     */
    @JvmName("ytpyvfbfhadywciw")
    public suspend fun instanceGenerations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceGenerations = mapped
    }

    /**
     * @param values Indicates whether current or previous generation instance types are included. The current generation instance types are recommended for use. Valid values are `current` and `previous`. Default is `current` and `previous` generation instance types.
     */
    @JvmName("djnpfcnlyufjdjsd")
    public suspend fun instanceGenerations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceGenerations = mapped
    }

    /**
     * @param value Indicate whether instance types with local storage volumes are `included`, `excluded`, or `required`. Default is `included`.
     */
    @JvmName("bilrcklwbitvctdt")
    public suspend fun localStorage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localStorage = mapped
    }

    /**
     * @param value List of local storage type names. Valid values are `hdd` and `ssd`. Default any storage type.
     */
    @JvmName("khpydggfkjqvotrm")
    public suspend fun localStorageTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localStorageTypes = mapped
    }

    /**
     * @param values List of local storage type names. Valid values are `hdd` and `ssd`. Default any storage type.
     */
    @JvmName("cwhmmjokoqimyjxx")
    public suspend fun localStorageTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.localStorageTypes = mapped
    }

    /**
     * @param value Block describing the minimum and maximum amount of memory (GiB) per vCPU. Default is no minimum or maximum.
     */
    @JvmName("suyskkyqwqbrikgx")
    public suspend
    fun memoryGibPerVcpu(`value`: FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memoryGibPerVcpu = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum amount of memory (GiB) per vCPU. Default is no minimum or maximum.
     */
    @JvmName("srlgcjywjupicuar")
    public suspend
    fun memoryGibPerVcpu(argument: suspend FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpuArgsBuilder.() -> Unit) {
        val toBeMapped =
            FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpuArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.memoryGibPerVcpu = mapped
    }

    /**
     * @param value The minimum and maximum amount of memory per vCPU, in GiB. Default is no minimum or maximum limits.
     */
    @JvmName("jmtjhwlfwxnwvvyv")
    public suspend
    fun memoryMib(`value`: FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryMibArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.memoryMib = mapped
    }

    /**
     * @param argument The minimum and maximum amount of memory per vCPU, in GiB. Default is no minimum or maximum limits.
     */
    @JvmName("pqcleskcivjhabal")
    public suspend
    fun memoryMib(argument: suspend FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryMibArgsBuilder.() -> Unit) {
        val toBeMapped =
            FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryMibArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.memoryMib = mapped
    }

    /**
     * @param value The minimum and maximum amount of network bandwidth, in gigabits per second (Gbps). Default is No minimum or maximum.
     */
    @JvmName("kvrgqniaijwspjyh")
    public suspend
    fun networkBandwidthGbps(`value`: FleetLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbpsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkBandwidthGbps = mapped
    }

    /**
     * @param argument The minimum and maximum amount of network bandwidth, in gigabits per second (Gbps). Default is No minimum or maximum.
     */
    @JvmName("pyarmskfqkqfumcl")
    public suspend
    fun networkBandwidthGbps(argument: suspend FleetLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbpsArgsBuilder.() -> Unit) {
        val toBeMapped =
            FleetLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbpsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.networkBandwidthGbps = mapped
    }

    /**
     * @param value Block describing the minimum and maximum number of network interfaces. Default is no minimum or maximum.
     */
    @JvmName("lgdopmvbuofqykmb")
    public suspend
    fun networkInterfaceCount(`value`: FleetLaunchTemplateConfigOverrideInstanceRequirementsNetworkInterfaceCountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceCount = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum number of network interfaces. Default is no minimum or maximum.
     */
    @JvmName("cegnxmvebypqqylv")
    public suspend
    fun networkInterfaceCount(argument: suspend FleetLaunchTemplateConfigOverrideInstanceRequirementsNetworkInterfaceCountArgsBuilder.() -> Unit) {
        val toBeMapped =
            FleetLaunchTemplateConfigOverrideInstanceRequirementsNetworkInterfaceCountArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.networkInterfaceCount = mapped
    }

    /**
     * @param value The price protection threshold for On-Demand Instances. This is the maximum you’ll pay for an On-Demand Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Default is 20.
     * If you set `target_capacity_unit_type` to `vcpu` or `memory-mib`, the price protection threshold is applied based on the per-vCPU or per-memory price instead of the per-instance price.
     */
    @JvmName("odofckmqrsjufvkl")
    public suspend fun onDemandMaxPricePercentageOverLowestPrice(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onDemandMaxPricePercentageOverLowestPrice = mapped
    }

    /**
     * @param value Indicate whether instance types must support On-Demand Instance Hibernation, either `true` or `false`. Default is `false`.
     */
    @JvmName("rmcfasrlpqlrfkkq")
    public suspend fun requireHibernateSupport(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireHibernateSupport = mapped
    }

    /**
     * @param value The price protection threshold for Spot Instances. This is the maximum you’ll pay for a Spot Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Default is 100.
     * If you set DesiredCapacityType to vcpu or memory-mib, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price.
     */
    @JvmName("vkmgbaovsbbnviuc")
    public suspend fun spotMaxPricePercentageOverLowestPrice(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotMaxPricePercentageOverLowestPrice = mapped
    }

    /**
     * @param value Block describing the minimum and maximum total local storage (GB). Default is no minimum or maximum.
     */
    @JvmName("tmijybsrwfxvdtdy")
    public suspend
    fun totalLocalStorageGb(`value`: FleetLaunchTemplateConfigOverrideInstanceRequirementsTotalLocalStorageGbArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.totalLocalStorageGb = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum total local storage (GB). Default is no minimum or maximum.
     */
    @JvmName("dfwqxbaarfqrsayc")
    public suspend
    fun totalLocalStorageGb(argument: suspend FleetLaunchTemplateConfigOverrideInstanceRequirementsTotalLocalStorageGbArgsBuilder.() -> Unit) {
        val toBeMapped =
            FleetLaunchTemplateConfigOverrideInstanceRequirementsTotalLocalStorageGbArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.totalLocalStorageGb = mapped
    }

    /**
     * @param value Block describing the minimum and maximum number of vCPUs. Default is no maximum.
     */
    @JvmName("nqptxppctxhcsmil")
    public suspend
    fun vcpuCount(`value`: FleetLaunchTemplateConfigOverrideInstanceRequirementsVcpuCountArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vcpuCount = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum number of vCPUs. Default is no maximum.
     */
    @JvmName("ltyocftuuonlmyxs")
    public suspend
    fun vcpuCount(argument: suspend FleetLaunchTemplateConfigOverrideInstanceRequirementsVcpuCountArgsBuilder.() -> Unit) {
        val toBeMapped =
            FleetLaunchTemplateConfigOverrideInstanceRequirementsVcpuCountArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.vcpuCount = mapped
    }

    internal fun build(): FleetLaunchTemplateConfigOverrideInstanceRequirementsArgs =
        FleetLaunchTemplateConfigOverrideInstanceRequirementsArgs(
            acceleratorCount = acceleratorCount,
            acceleratorManufacturers = acceleratorManufacturers,
            acceleratorNames = acceleratorNames,
            acceleratorTotalMemoryMib = acceleratorTotalMemoryMib,
            acceleratorTypes = acceleratorTypes,
            allowedInstanceTypes = allowedInstanceTypes,
            bareMetal = bareMetal,
            baselineEbsBandwidthMbps = baselineEbsBandwidthMbps,
            burstablePerformance = burstablePerformance,
            cpuManufacturers = cpuManufacturers,
            excludedInstanceTypes = excludedInstanceTypes,
            instanceGenerations = instanceGenerations,
            localStorage = localStorage,
            localStorageTypes = localStorageTypes,
            memoryGibPerVcpu = memoryGibPerVcpu,
            memoryMib = memoryMib ?: throw PulumiNullFieldException("memoryMib"),
            networkBandwidthGbps = networkBandwidthGbps,
            networkInterfaceCount = networkInterfaceCount,
            onDemandMaxPricePercentageOverLowestPrice = onDemandMaxPricePercentageOverLowestPrice,
            requireHibernateSupport = requireHibernateSupport,
            spotMaxPricePercentageOverLowestPrice = spotMaxPricePercentageOverLowestPrice,
            totalLocalStorageGb = totalLocalStorageGb,
            vcpuCount = vcpuCount ?: throw PulumiNullFieldException("vcpuCount"),
        )
}
