@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property max The maximum number of vCPUs. To specify no maximum limit, omit this parameter.
 * @property min The minimum number of vCPUs. To specify no minimum limit, specify `0`.
 */
public data class FleetLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgs(
    public val max: Output<Int>? = null,
    public val min: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgs> {
    override fun toJava():
        com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgs =
        com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgs.builder()
            .max(max?.applyValue({ args0 -> args0 }))
            .min(min?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgs].
 */
@PulumiTagMarker
public class
FleetLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgsBuilder
internal constructor() {
    private var max: Output<Int>? = null

    private var min: Output<Int>? = null

    /**
     * @param value The maximum number of vCPUs. To specify no maximum limit, omit this parameter.
     */
    @JvmName("augryqhwftvuweaa")
    public suspend fun max(`value`: Output<Int>) {
        this.max = value
    }

    /**
     * @param value The minimum number of vCPUs. To specify no minimum limit, specify `0`.
     */
    @JvmName("ebygnwntedeyoipu")
    public suspend fun min(`value`: Output<Int>) {
        this.min = value
    }

    /**
     * @param value The maximum number of vCPUs. To specify no maximum limit, omit this parameter.
     */
    @JvmName("oikvhvhndjwskeil")
    public suspend fun max(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.max = mapped
    }

    /**
     * @param value The minimum number of vCPUs. To specify no minimum limit, specify `0`.
     */
    @JvmName("roqeyokwfcgshpok")
    public suspend fun min(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.min = mapped
    }

    internal fun build():
        FleetLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgs =
        FleetLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgs(
            max = max,
            min = min,
        )
}
