@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpuArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property max The maximum number of vCPUs. To specify no maximum limit, omit this parameter.
 * @property min The minimum number of vCPUs. To specify no minimum limit, specify `0`.
 */
public data class FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpuArgs(
    public val max: Output<Double>? = null,
    public val min: Output<Double>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpuArgs> {
    override fun toJava():
        com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpuArgs =
        com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpuArgs.builder()
            .max(max?.applyValue({ args0 -> args0 }))
            .min(min?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpuArgs].
 */
@PulumiTagMarker
public class FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpuArgsBuilder
internal constructor() {
    private var max: Output<Double>? = null

    private var min: Output<Double>? = null

    /**
     * @param value The maximum number of vCPUs. To specify no maximum limit, omit this parameter.
     */
    @JvmName("nieuysxqyscwevny")
    public suspend fun max(`value`: Output<Double>) {
        this.max = value
    }

    /**
     * @param value The minimum number of vCPUs. To specify no minimum limit, specify `0`.
     */
    @JvmName("uuaeungucqhhqoce")
    public suspend fun min(`value`: Output<Double>) {
        this.min = value
    }

    /**
     * @param value The maximum number of vCPUs. To specify no maximum limit, omit this parameter.
     */
    @JvmName("eqtilyyfsojvoybb")
    public suspend fun max(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.max = mapped
    }

    /**
     * @param value The minimum number of vCPUs. To specify no minimum limit, specify `0`.
     */
    @JvmName("wlhuvgyihroyojos")
    public suspend fun min(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.min = mapped
    }

    internal fun build(): FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpuArgs =
        FleetLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpuArgs(
            max = max,
            min = min,
        )
}
