@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.FleetOnDemandOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property allocationStrategy The order of the launch template overrides to use in fulfilling On-Demand capacity. Valid values: `lowestPrice`, `prioritized`. Default: `lowestPrice`.
 * @property maxTotalPrice The maximum amount per hour for On-Demand Instances that you're willing to pay.
 * @property minTargetCapacity The minimum target capacity for On-Demand Instances in the fleet. If the minimum target capacity is not reached, the fleet launches no instances. Supported only for fleets of type `instant`.
 * If you specify `min_target_capacity`, at least one of the following must be specified: `single_availability_zone` or `single_instance_type`.
 * @property singleAvailabilityZone Indicates that the fleet launches all On-Demand Instances into a single Availability Zone. Supported only for fleets of type `instant`.
 * @property singleInstanceType Indicates that the fleet uses a single instance type to launch all On-Demand Instances in the fleet. Supported only for fleets of type `instant`.
 */
public data class FleetOnDemandOptionsArgs(
    public val allocationStrategy: Output<String>? = null,
    public val maxTotalPrice: Output<String>? = null,
    public val minTargetCapacity: Output<Int>? = null,
    public val singleAvailabilityZone: Output<Boolean>? = null,
    public val singleInstanceType: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.FleetOnDemandOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.FleetOnDemandOptionsArgs =
        com.pulumi.aws.ec2.inputs.FleetOnDemandOptionsArgs.builder()
            .allocationStrategy(allocationStrategy?.applyValue({ args0 -> args0 }))
            .maxTotalPrice(maxTotalPrice?.applyValue({ args0 -> args0 }))
            .minTargetCapacity(minTargetCapacity?.applyValue({ args0 -> args0 }))
            .singleAvailabilityZone(singleAvailabilityZone?.applyValue({ args0 -> args0 }))
            .singleInstanceType(singleInstanceType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetOnDemandOptionsArgs].
 */
@PulumiTagMarker
public class FleetOnDemandOptionsArgsBuilder internal constructor() {
    private var allocationStrategy: Output<String>? = null

    private var maxTotalPrice: Output<String>? = null

    private var minTargetCapacity: Output<Int>? = null

    private var singleAvailabilityZone: Output<Boolean>? = null

    private var singleInstanceType: Output<Boolean>? = null

    /**
     * @param value The order of the launch template overrides to use in fulfilling On-Demand capacity. Valid values: `lowestPrice`, `prioritized`. Default: `lowestPrice`.
     */
    @JvmName("qguauuwryfbmqtjq")
    public suspend fun allocationStrategy(`value`: Output<String>) {
        this.allocationStrategy = value
    }

    /**
     * @param value The maximum amount per hour for On-Demand Instances that you're willing to pay.
     */
    @JvmName("rmjrtwbqijcofvta")
    public suspend fun maxTotalPrice(`value`: Output<String>) {
        this.maxTotalPrice = value
    }

    /**
     * @param value The minimum target capacity for On-Demand Instances in the fleet. If the minimum target capacity is not reached, the fleet launches no instances. Supported only for fleets of type `instant`.
     * If you specify `min_target_capacity`, at least one of the following must be specified: `single_availability_zone` or `single_instance_type`.
     */
    @JvmName("fdqfaijnqxbudptx")
    public suspend fun minTargetCapacity(`value`: Output<Int>) {
        this.minTargetCapacity = value
    }

    /**
     * @param value Indicates that the fleet launches all On-Demand Instances into a single Availability Zone. Supported only for fleets of type `instant`.
     */
    @JvmName("hgkbycqwsnrdlicj")
    public suspend fun singleAvailabilityZone(`value`: Output<Boolean>) {
        this.singleAvailabilityZone = value
    }

    /**
     * @param value Indicates that the fleet uses a single instance type to launch all On-Demand Instances in the fleet. Supported only for fleets of type `instant`.
     */
    @JvmName("lhlyuvxbftgqduyg")
    public suspend fun singleInstanceType(`value`: Output<Boolean>) {
        this.singleInstanceType = value
    }

    /**
     * @param value The order of the launch template overrides to use in fulfilling On-Demand capacity. Valid values: `lowestPrice`, `prioritized`. Default: `lowestPrice`.
     */
    @JvmName("yyoqervrdfqgogmv")
    public suspend fun allocationStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationStrategy = mapped
    }

    /**
     * @param value The maximum amount per hour for On-Demand Instances that you're willing to pay.
     */
    @JvmName("jsismougqggbxqib")
    public suspend fun maxTotalPrice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxTotalPrice = mapped
    }

    /**
     * @param value The minimum target capacity for On-Demand Instances in the fleet. If the minimum target capacity is not reached, the fleet launches no instances. Supported only for fleets of type `instant`.
     * If you specify `min_target_capacity`, at least one of the following must be specified: `single_availability_zone` or `single_instance_type`.
     */
    @JvmName("npvtacvcjgnsouxn")
    public suspend fun minTargetCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minTargetCapacity = mapped
    }

    /**
     * @param value Indicates that the fleet launches all On-Demand Instances into a single Availability Zone. Supported only for fleets of type `instant`.
     */
    @JvmName("ixwafrsagriitgou")
    public suspend fun singleAvailabilityZone(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleAvailabilityZone = mapped
    }

    /**
     * @param value Indicates that the fleet uses a single instance type to launch all On-Demand Instances in the fleet. Supported only for fleets of type `instant`.
     */
    @JvmName("dimehoasnvwuqpby")
    public suspend fun singleInstanceType(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleInstanceType = mapped
    }

    internal fun build(): FleetOnDemandOptionsArgs = FleetOnDemandOptionsArgs(
        allocationStrategy = allocationStrategy,
        maxTotalPrice = maxTotalPrice,
        minTargetCapacity = minTargetCapacity,
        singleAvailabilityZone = singleAvailabilityZone,
        singleInstanceType = singleInstanceType,
    )
}
