@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.FleetSpotOptionsMaintenanceStrategiesCapacityRebalanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property replacementStrategy The replacement strategy to use. Only available for fleets of `type` set to `maintain`. Valid values: `launch`.
 * @property terminationDelay
 */
public data class FleetSpotOptionsMaintenanceStrategiesCapacityRebalanceArgs(
    public val replacementStrategy: Output<String>? = null,
    public val terminationDelay: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ec2.inputs.FleetSpotOptionsMaintenanceStrategiesCapacityRebalanceArgs> {
    override fun toJava():
        com.pulumi.aws.ec2.inputs.FleetSpotOptionsMaintenanceStrategiesCapacityRebalanceArgs =
        com.pulumi.aws.ec2.inputs.FleetSpotOptionsMaintenanceStrategiesCapacityRebalanceArgs.builder()
            .replacementStrategy(replacementStrategy?.applyValue({ args0 -> args0 }))
            .terminationDelay(terminationDelay?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetSpotOptionsMaintenanceStrategiesCapacityRebalanceArgs].
 */
@PulumiTagMarker
public class FleetSpotOptionsMaintenanceStrategiesCapacityRebalanceArgsBuilder internal
constructor() {
    private var replacementStrategy: Output<String>? = null

    private var terminationDelay: Output<Int>? = null

    /**
     * @param value The replacement strategy to use. Only available for fleets of `type` set to `maintain`. Valid values: `launch`.
     */
    @JvmName("qernbthtmdgupccx")
    public suspend fun replacementStrategy(`value`: Output<String>) {
        this.replacementStrategy = value
    }

    /**
     * @param value
     */
    @JvmName("eryettjjpotieunc")
    public suspend fun terminationDelay(`value`: Output<Int>) {
        this.terminationDelay = value
    }

    /**
     * @param value The replacement strategy to use. Only available for fleets of `type` set to `maintain`. Valid values: `launch`.
     */
    @JvmName("bvtqupmsbpmbvueb")
    public suspend fun replacementStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replacementStrategy = mapped
    }

    /**
     * @param value
     */
    @JvmName("xmpxdpjnesjomhna")
    public suspend fun terminationDelay(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terminationDelay = mapped
    }

    internal fun build(): FleetSpotOptionsMaintenanceStrategiesCapacityRebalanceArgs =
        FleetSpotOptionsMaintenanceStrategiesCapacityRebalanceArgs(
            replacementStrategy = replacementStrategy,
            terminationDelay = terminationDelay,
        )
}
