@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.FleetTargetCapacitySpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property defaultTargetCapacityType Default target capacity type. Valid values: `on-demand`, `spot`.
 * @property onDemandTargetCapacity The number of On-Demand units to request.
 * @property spotTargetCapacity The number of Spot units to request.
 * @property targetCapacityUnitType The unit for the target capacity.
 * If you specify `target_capacity_unit_type`, `instance_requirements` must be specified.
 * @property totalTargetCapacity The number of units to request, filled using `default_target_capacity_type`.
 */
public data class FleetTargetCapacitySpecificationArgs(
    public val defaultTargetCapacityType: Output<String>,
    public val onDemandTargetCapacity: Output<Int>? = null,
    public val spotTargetCapacity: Output<Int>? = null,
    public val targetCapacityUnitType: Output<String>? = null,
    public val totalTargetCapacity: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.FleetTargetCapacitySpecificationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.FleetTargetCapacitySpecificationArgs =
        com.pulumi.aws.ec2.inputs.FleetTargetCapacitySpecificationArgs.builder()
            .defaultTargetCapacityType(defaultTargetCapacityType.applyValue({ args0 -> args0 }))
            .onDemandTargetCapacity(onDemandTargetCapacity?.applyValue({ args0 -> args0 }))
            .spotTargetCapacity(spotTargetCapacity?.applyValue({ args0 -> args0 }))
            .targetCapacityUnitType(targetCapacityUnitType?.applyValue({ args0 -> args0 }))
            .totalTargetCapacity(totalTargetCapacity.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetTargetCapacitySpecificationArgs].
 */
@PulumiTagMarker
public class FleetTargetCapacitySpecificationArgsBuilder internal constructor() {
    private var defaultTargetCapacityType: Output<String>? = null

    private var onDemandTargetCapacity: Output<Int>? = null

    private var spotTargetCapacity: Output<Int>? = null

    private var targetCapacityUnitType: Output<String>? = null

    private var totalTargetCapacity: Output<Int>? = null

    /**
     * @param value Default target capacity type. Valid values: `on-demand`, `spot`.
     */
    @JvmName("nvvpyjnjdutwouvl")
    public suspend fun defaultTargetCapacityType(`value`: Output<String>) {
        this.defaultTargetCapacityType = value
    }

    /**
     * @param value The number of On-Demand units to request.
     */
    @JvmName("xcecwqhhpeyqfovi")
    public suspend fun onDemandTargetCapacity(`value`: Output<Int>) {
        this.onDemandTargetCapacity = value
    }

    /**
     * @param value The number of Spot units to request.
     */
    @JvmName("bcdhuqohhjtxhais")
    public suspend fun spotTargetCapacity(`value`: Output<Int>) {
        this.spotTargetCapacity = value
    }

    /**
     * @param value The unit for the target capacity.
     * If you specify `target_capacity_unit_type`, `instance_requirements` must be specified.
     */
    @JvmName("mqbkrsxfbpylfefn")
    public suspend fun targetCapacityUnitType(`value`: Output<String>) {
        this.targetCapacityUnitType = value
    }

    /**
     * @param value The number of units to request, filled using `default_target_capacity_type`.
     */
    @JvmName("llbbryoduuetpufu")
    public suspend fun totalTargetCapacity(`value`: Output<Int>) {
        this.totalTargetCapacity = value
    }

    /**
     * @param value Default target capacity type. Valid values: `on-demand`, `spot`.
     */
    @JvmName("sgnhlihlodiwcjwo")
    public suspend fun defaultTargetCapacityType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultTargetCapacityType = mapped
    }

    /**
     * @param value The number of On-Demand units to request.
     */
    @JvmName("lqxltmhmbrqvakmd")
    public suspend fun onDemandTargetCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onDemandTargetCapacity = mapped
    }

    /**
     * @param value The number of Spot units to request.
     */
    @JvmName("vjhwepchlwxdvcfp")
    public suspend fun spotTargetCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotTargetCapacity = mapped
    }

    /**
     * @param value The unit for the target capacity.
     * If you specify `target_capacity_unit_type`, `instance_requirements` must be specified.
     */
    @JvmName("qwqmfafimjvtwhpq")
    public suspend fun targetCapacityUnitType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetCapacityUnitType = mapped
    }

    /**
     * @param value The number of units to request, filled using `default_target_capacity_type`.
     */
    @JvmName("snltfwutluuclcww")
    public suspend fun totalTargetCapacity(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.totalTargetCapacity = mapped
    }

    internal fun build(): FleetTargetCapacitySpecificationArgs = FleetTargetCapacitySpecificationArgs(
        defaultTargetCapacityType = defaultTargetCapacityType ?: throw
            PulumiNullFieldException("defaultTargetCapacityType"),
        onDemandTargetCapacity = onDemandTargetCapacity,
        spotTargetCapacity = spotTargetCapacity,
        targetCapacityUnitType = targetCapacityUnitType,
        totalTargetCapacity = totalTargetCapacity ?: throw PulumiNullFieldException("totalTargetCapacity"),
    )
}
