@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetCustomerGatewayPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCustomerGateway.
 * @property filters One or more [name-value pairs][dcg-filters] to filter by.
 * [dcg-filters]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeCustomerGateways.html
 * @property id ID of the gateway.
 * @property tags Map of key-value pairs assigned to the gateway.
 */
public data class GetCustomerGatewayPlainArgs(
    public val filters: List<GetCustomerGatewayFilter>? = null,
    public val id: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetCustomerGatewayPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetCustomerGatewayPlainArgs =
        com.pulumi.aws.ec2.inputs.GetCustomerGatewayPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .id(id?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetCustomerGatewayPlainArgs].
 */
@PulumiTagMarker
public class GetCustomerGatewayPlainArgsBuilder internal constructor() {
    private var filters: List<GetCustomerGatewayFilter>? = null

    private var id: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value One or more [name-value pairs][dcg-filters] to filter by.
     * [dcg-filters]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeCustomerGateways.html
     */
    @JvmName("nucupmpqdhmqscma")
    public suspend fun filters(`value`: List<GetCustomerGatewayFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more [name-value pairs][dcg-filters] to filter by.
     * [dcg-filters]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeCustomerGateways.html
     */
    @JvmName("jklswsgmkjbajcls")
    public suspend fun filters(argument: List<suspend GetCustomerGatewayFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetCustomerGatewayFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more [name-value pairs][dcg-filters] to filter by.
     * [dcg-filters]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeCustomerGateways.html
     */
    @JvmName("nybcnnqweydcbnik")
    public suspend fun filters(vararg argument: suspend GetCustomerGatewayFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetCustomerGatewayFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more [name-value pairs][dcg-filters] to filter by.
     * [dcg-filters]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeCustomerGateways.html
     */
    @JvmName("jkmstqpjomnduaty")
    public suspend fun filters(argument: suspend GetCustomerGatewayFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetCustomerGatewayFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more [name-value pairs][dcg-filters] to filter by.
     * [dcg-filters]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeCustomerGateways.html
     */
    @JvmName("rritloecjdjsyqkm")
    public suspend fun filters(vararg values: GetCustomerGatewayFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value ID of the gateway.
     */
    @JvmName("uqlpabshcpmmgdsx")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Map of key-value pairs assigned to the gateway.
     */
    @JvmName("modbxtqoetohkpeg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of key-value pairs assigned to the gateway.
     */
    @JvmName("ykhcmpelstijrhja")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetCustomerGatewayPlainArgs = GetCustomerGatewayPlainArgs(
        filters = filters,
        id = id,
        tags = tags,
    )
}
