@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetInstanceFilter.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name
 * @property values
 */
public data class GetInstanceFilter(
    public val name: String,
    public val values: List<String>,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetInstanceFilter> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetInstanceFilter =
        com.pulumi.aws.ec2.inputs.GetInstanceFilter.builder()
            .name(name.let({ args0 -> args0 }))
            .values(values.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetInstanceFilter].
 */
@PulumiTagMarker
public class GetInstanceFilterBuilder internal constructor() {
    private var name: String? = null

    private var values: List<String>? = null

    /**
     * @param value
     */
    @JvmName("xfjlomciuhubdfwm")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("lmplyhmgviaqissa")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    /**
     * @param values
     */
    @JvmName("apthwiuphtcjuolr")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    internal fun build(): GetInstanceFilter = GetInstanceFilter(
        name = name ?: throw PulumiNullFieldException("name"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
