@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetInstancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstance.
 * @property filters One or more name/value pairs to use as filters. There are
 * several valid keys, for a full reference, check out
 * [describe-instances in the AWS CLI reference][1].
 * @property getPasswordData If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
 * @property getUserData Retrieve Base64 encoded User Data contents into the `user_data_base64` attribute. A SHA-1 hash of the User Data contents will always be present in the `user_data` attribute. Defaults to `false`.
 * > **NOTE:** At least one of `filter`, `instance_tags`, or `instance_id` must be specified.
 * > **NOTE:** If anything other than a single match is returned by the search,
 * this call will fail. Ensure that your search is specific enough to return
 * a single Instance ID only.
 * @property instanceId Specify the exact Instance ID with which to populate the data source.
 * @property instanceTags Map of tags, each pair of which must
 * exactly match a pair on the desired Instance.
 * @property tags Map of tags assigned to the Instance.
 */
public data class GetInstancePlainArgs(
    public val filters: List<GetInstanceFilter>? = null,
    public val getPasswordData: Boolean? = null,
    public val getUserData: Boolean? = null,
    public val instanceId: String? = null,
    public val instanceTags: Map<String, String>? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetInstancePlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetInstancePlainArgs =
        com.pulumi.aws.ec2.inputs.GetInstancePlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .getPasswordData(getPasswordData?.let({ args0 -> args0 }))
            .getUserData(getUserData?.let({ args0 -> args0 }))
            .instanceId(instanceId?.let({ args0 -> args0 }))
            .instanceTags(
                instanceTags?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetInstancePlainArgs].
 */
@PulumiTagMarker
public class GetInstancePlainArgsBuilder internal constructor() {
    private var filters: List<GetInstanceFilter>? = null

    private var getPasswordData: Boolean? = null

    private var getUserData: Boolean? = null

    private var instanceId: String? = null

    private var instanceTags: Map<String, String>? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value One or more name/value pairs to use as filters. There are
     * several valid keys, for a full reference, check out
     * [describe-instances in the AWS CLI reference][1].
     */
    @JvmName("qwcuaxcutaosfdca")
    public suspend fun filters(`value`: List<GetInstanceFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to use as filters. There are
     * several valid keys, for a full reference, check out
     * [describe-instances in the AWS CLI reference][1].
     */
    @JvmName("vsonnmkqwxfgvbqj")
    public suspend fun filters(argument: List<suspend GetInstanceFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetInstanceFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to use as filters. There are
     * several valid keys, for a full reference, check out
     * [describe-instances in the AWS CLI reference][1].
     */
    @JvmName("lgmorjdkcwvjtyqi")
    public suspend fun filters(vararg argument: suspend GetInstanceFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetInstanceFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to use as filters. There are
     * several valid keys, for a full reference, check out
     * [describe-instances in the AWS CLI reference][1].
     */
    @JvmName("nwsixtsfdovnvesq")
    public suspend fun filters(argument: suspend GetInstanceFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetInstanceFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more name/value pairs to use as filters. There are
     * several valid keys, for a full reference, check out
     * [describe-instances in the AWS CLI reference][1].
     */
    @JvmName("csktatsoadripdls")
    public suspend fun filters(vararg values: GetInstanceFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
     */
    @JvmName("ksywbtexuosmbjbp")
    public suspend fun getPasswordData(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.getPasswordData = mapped
    }

    /**
     * @param value Retrieve Base64 encoded User Data contents into the `user_data_base64` attribute. A SHA-1 hash of the User Data contents will always be present in the `user_data` attribute. Defaults to `false`.
     * > **NOTE:** At least one of `filter`, `instance_tags`, or `instance_id` must be specified.
     * > **NOTE:** If anything other than a single match is returned by the search,
     * this call will fail. Ensure that your search is specific enough to return
     * a single Instance ID only.
     */
    @JvmName("yggicaootbenhcns")
    public suspend fun getUserData(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.getUserData = mapped
    }

    /**
     * @param value Specify the exact Instance ID with which to populate the data source.
     */
    @JvmName("udcqkdhafnruxqfq")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value Map of tags, each pair of which must
     * exactly match a pair on the desired Instance.
     */
    @JvmName("gndgdfkxwybwuyqc")
    public suspend fun instanceTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceTags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must
     * exactly match a pair on the desired Instance.
     */
    @JvmName("bjnkamdskkmvnabw")
    public fun instanceTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceTags = mapped
    }

    /**
     * @param value Map of tags assigned to the Instance.
     */
    @JvmName("kgqnmrcaenvqymgs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags assigned to the Instance.
     */
    @JvmName("mcfyjqyfaamafhmq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetInstancePlainArgs = GetInstancePlainArgs(
        filters = filters,
        getPasswordData = getPasswordData,
        getUserData = getUserData,
        instanceId = instanceId,
        instanceTags = instanceTags,
        tags = tags,
    )
}
