@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetInstancesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstances.
 * @property filters One or more name/value pairs to use as filters. There are
 * several valid keys, for a full reference, check out
 * [describe-instances in the AWS CLI reference][1].
 * @property instanceStateNames List of instance states that should be applicable to the desired instances. The permitted values are: `pending, running, shutting-down, stopped, stopping, terminated`. The default value is `running`.
 * @property instanceTags Map of tags, each pair of which must
 * exactly match a pair on desired instances.
 */
public data class GetInstancesPlainArgs(
    public val filters: List<GetInstancesFilter>? = null,
    public val instanceStateNames: List<String>? = null,
    public val instanceTags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetInstancesPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetInstancesPlainArgs =
        com.pulumi.aws.ec2.inputs.GetInstancesPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .instanceStateNames(instanceStateNames?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceTags(
                instanceTags?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [GetInstancesPlainArgs].
 */
@PulumiTagMarker
public class GetInstancesPlainArgsBuilder internal constructor() {
    private var filters: List<GetInstancesFilter>? = null

    private var instanceStateNames: List<String>? = null

    private var instanceTags: Map<String, String>? = null

    /**
     * @param value One or more name/value pairs to use as filters. There are
     * several valid keys, for a full reference, check out
     * [describe-instances in the AWS CLI reference][1].
     */
    @JvmName("pqrcnqojqjhtenyh")
    public suspend fun filters(`value`: List<GetInstancesFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to use as filters. There are
     * several valid keys, for a full reference, check out
     * [describe-instances in the AWS CLI reference][1].
     */
    @JvmName("enfdbvjcgsduhbjp")
    public suspend fun filters(argument: List<suspend GetInstancesFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetInstancesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to use as filters. There are
     * several valid keys, for a full reference, check out
     * [describe-instances in the AWS CLI reference][1].
     */
    @JvmName("kdgybltxstlldikh")
    public suspend fun filters(vararg argument: suspend GetInstancesFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetInstancesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to use as filters. There are
     * several valid keys, for a full reference, check out
     * [describe-instances in the AWS CLI reference][1].
     */
    @JvmName("uaqotbfdurbsbpjp")
    public suspend fun filters(argument: suspend GetInstancesFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetInstancesFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more name/value pairs to use as filters. There are
     * several valid keys, for a full reference, check out
     * [describe-instances in the AWS CLI reference][1].
     */
    @JvmName("aemfknngcrgpspvr")
    public suspend fun filters(vararg values: GetInstancesFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value List of instance states that should be applicable to the desired instances. The permitted values are: `pending, running, shutting-down, stopped, stopping, terminated`. The default value is `running`.
     */
    @JvmName("rxxtnprychxickjv")
    public suspend fun instanceStateNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceStateNames = mapped
    }

    /**
     * @param values List of instance states that should be applicable to the desired instances. The permitted values are: `pending, running, shutting-down, stopped, stopping, terminated`. The default value is `running`.
     */
    @JvmName("mlwnthmdievupmhu")
    public suspend fun instanceStateNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceStateNames = mapped
    }

    /**
     * @param value Map of tags, each pair of which must
     * exactly match a pair on desired instances.
     */
    @JvmName("bkwcvklihifepyde")
    public suspend fun instanceTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceTags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must
     * exactly match a pair on desired instances.
     */
    @JvmName("cytsvrcyuwipeupe")
    public fun instanceTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceTags = mapped
    }

    internal fun build(): GetInstancesPlainArgs = GetInstancesPlainArgs(
        filters = filters,
        instanceStateNames = instanceStateNames,
        instanceTags = instanceTags,
    )
}
