@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetInternetGatewayPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInternetGateway.
 * @property filters Custom filter block as described below.
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 * @property internetGatewayId ID of the specific Internet Gateway to retrieve.
 * @property tags Map of tags, each pair of which must exactly match
 * a pair on the desired Internet Gateway.
 */
public data class GetInternetGatewayPlainArgs(
    public val filters: List<GetInternetGatewayFilter>? = null,
    public val internetGatewayId: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetInternetGatewayPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetInternetGatewayPlainArgs =
        com.pulumi.aws.ec2.inputs.GetInternetGatewayPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .internetGatewayId(internetGatewayId?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetInternetGatewayPlainArgs].
 */
@PulumiTagMarker
public class GetInternetGatewayPlainArgsBuilder internal constructor() {
    private var filters: List<GetInternetGatewayFilter>? = null

    private var internetGatewayId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("rpmvcrwyfqngogqa")
    public suspend fun filters(`value`: List<GetInternetGatewayFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("kfaqcpmxhtakcufo")
    public suspend fun filters(argument: List<suspend GetInternetGatewayFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetInternetGatewayFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("qnngekqysovyomvw")
    public suspend fun filters(vararg argument: suspend GetInternetGatewayFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetInternetGatewayFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("fefxeoheaeopyula")
    public suspend fun filters(argument: suspend GetInternetGatewayFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetInternetGatewayFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("kqirspcqtcddyovt")
    public suspend fun filters(vararg values: GetInternetGatewayFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value ID of the specific Internet Gateway to retrieve.
     */
    @JvmName("hivwfnktjdwkypjm")
    public suspend fun internetGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.internetGatewayId = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match
     * a pair on the desired Internet Gateway.
     */
    @JvmName("pximmyqcrykcrbjt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match
     * a pair on the desired Internet Gateway.
     */
    @JvmName("satemomhedydyyuf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetInternetGatewayPlainArgs = GetInternetGatewayPlainArgs(
        filters = filters,
        internetGatewayId = internetGatewayId,
        tags = tags,
    )
}
