@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetLaunchConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLaunchConfiguration.
 * @property name Name of the launch configuration.
 */
public data class GetLaunchConfigurationPlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetLaunchConfigurationPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetLaunchConfigurationPlainArgs =
        com.pulumi.aws.ec2.inputs.GetLaunchConfigurationPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLaunchConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetLaunchConfigurationPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Name of the launch configuration.
     */
    @JvmName("ovpfttxkfgerhice")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetLaunchConfigurationPlainArgs = GetLaunchConfigurationPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
