@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetLaunchTemplatePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLaunchTemplate.
 * @property filters Configuration block(s) for filtering. Detailed below.
 * @property id ID of the specific launch template to retrieve.
 * @property name Name of the launch template.
 * @property tags Map of tags, each pair of which must exactly match a pair on the desired Launch Template.
 */
public data class GetLaunchTemplatePlainArgs(
    public val filters: List<GetLaunchTemplateFilter>? = null,
    public val id: String? = null,
    public val name: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetLaunchTemplatePlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetLaunchTemplatePlainArgs =
        com.pulumi.aws.ec2.inputs.GetLaunchTemplatePlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .id(id?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetLaunchTemplatePlainArgs].
 */
@PulumiTagMarker
public class GetLaunchTemplatePlainArgsBuilder internal constructor() {
    private var filters: List<GetLaunchTemplateFilter>? = null

    private var id: String? = null

    private var name: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("gobamdqvawycyqgw")
    public suspend fun filters(`value`: List<GetLaunchTemplateFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("wxylqcrkklrbrvme")
    public suspend fun filters(argument: List<suspend GetLaunchTemplateFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetLaunchTemplateFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("vhsteumanrphwcrt")
    public suspend fun filters(vararg argument: suspend GetLaunchTemplateFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetLaunchTemplateFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("iyisltubffgwrpsy")
    public suspend fun filters(argument: suspend GetLaunchTemplateFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetLaunchTemplateFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("fnvcaxfonjjmlsjr")
    public suspend fun filters(vararg values: GetLaunchTemplateFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value ID of the specific launch template to retrieve.
     */
    @JvmName("wrxnekrodoqgwdtn")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Name of the launch template.
     */
    @JvmName("tkpwdqjdpcmxssaf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match a pair on the desired Launch Template.
     */
    @JvmName("jxufwypqhlefdctx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match a pair on the desired Launch Template.
     */
    @JvmName("urmpfcqxylgjdxkx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetLaunchTemplatePlainArgs = GetLaunchTemplatePlainArgs(
        filters = filters,
        id = id,
        name = name,
        tags = tags,
    )
}
