@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetLocalGatewayPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLocalGateway.
 * @property filters Custom filter block as described below.
 * @property id Id of the specific Local Gateway to retrieve.
 * @property state Current state of the desired Local Gateway.
 * Can be either `"pending"` or `"available"`.
 * @property tags Mapping of tags, each pair of which must exactly match
 * a pair on the desired Local Gateway.
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 */
public data class GetLocalGatewayPlainArgs(
    public val filters: List<GetLocalGatewayFilter>? = null,
    public val id: String? = null,
    public val state: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetLocalGatewayPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetLocalGatewayPlainArgs =
        com.pulumi.aws.ec2.inputs.GetLocalGatewayPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .id(id?.let({ args0 -> args0 }))
            .state(state?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetLocalGatewayPlainArgs].
 */
@PulumiTagMarker
public class GetLocalGatewayPlainArgsBuilder internal constructor() {
    private var filters: List<GetLocalGatewayFilter>? = null

    private var id: String? = null

    private var state: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Custom filter block as described below.
     */
    @JvmName("gmsnlipveifthjip")
    public suspend fun filters(`value`: List<GetLocalGatewayFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("muyekdpogqmrbaox")
    public suspend fun filters(argument: List<suspend GetLocalGatewayFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetLocalGatewayFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("gkvdvagpfdbbhtan")
    public suspend fun filters(vararg argument: suspend GetLocalGatewayFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetLocalGatewayFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("vynmyvweayunxrrr")
    public suspend fun filters(argument: suspend GetLocalGatewayFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetLocalGatewayFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     */
    @JvmName("mpfqtxvghwqoxlmr")
    public suspend fun filters(vararg values: GetLocalGatewayFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Id of the specific Local Gateway to retrieve.
     */
    @JvmName("gwimujcfbqpwpunl")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Current state of the desired Local Gateway.
     * Can be either `"pending"` or `"available"`.
     */
    @JvmName("ixgowgklcyxtivfh")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.state = mapped
    }

    /**
     * @param value Mapping of tags, each pair of which must exactly match
     * a pair on the desired Local Gateway.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("drxkfclrvnjmgduf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Mapping of tags, each pair of which must exactly match
     * a pair on the desired Local Gateway.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("cqaetusyqsnnroju")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetLocalGatewayPlainArgs = GetLocalGatewayPlainArgs(
        filters = filters,
        id = id,
        state = state,
        tags = tags,
    )
}
