@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetLocalGatewayRouteTablePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLocalGatewayRouteTable.
 * @property filters
 * @property localGatewayId ID of the specific local gateway route table to retrieve.
 * @property localGatewayRouteTableId Local Gateway Route Table Id assigned to desired local gateway route table
 * @property outpostArn ARN of the Outpost the local gateway route table is associated with.
 * @property state State of the local gateway route table.
 * @property tags Mapping of tags, each pair of which must exactly match
 * a pair on the desired local gateway route table.
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 */
public data class GetLocalGatewayRouteTablePlainArgs(
    public val filters: List<GetLocalGatewayRouteTableFilter>? = null,
    public val localGatewayId: String? = null,
    public val localGatewayRouteTableId: String? = null,
    public val outpostArn: String? = null,
    public val state: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetLocalGatewayRouteTablePlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetLocalGatewayRouteTablePlainArgs =
        com.pulumi.aws.ec2.inputs.GetLocalGatewayRouteTablePlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .localGatewayId(localGatewayId?.let({ args0 -> args0 }))
            .localGatewayRouteTableId(localGatewayRouteTableId?.let({ args0 -> args0 }))
            .outpostArn(outpostArn?.let({ args0 -> args0 }))
            .state(state?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetLocalGatewayRouteTablePlainArgs].
 */
@PulumiTagMarker
public class GetLocalGatewayRouteTablePlainArgsBuilder internal constructor() {
    private var filters: List<GetLocalGatewayRouteTableFilter>? = null

    private var localGatewayId: String? = null

    private var localGatewayRouteTableId: String? = null

    private var outpostArn: String? = null

    private var state: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value
     */
    @JvmName("udpdrafaoaulmjms")
    public suspend fun filters(`value`: List<GetLocalGatewayRouteTableFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qwcudjcasoeryphf")
    public suspend
    fun filters(argument: List<suspend GetLocalGatewayRouteTableFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetLocalGatewayRouteTableFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument
     */
    @JvmName("oyvdpopwnqykphyq")
    public suspend fun filters(
        vararg
        argument: suspend GetLocalGatewayRouteTableFilterBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GetLocalGatewayRouteTableFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument
     */
    @JvmName("tqvaudxtqhonhvfm")
    public suspend fun filters(argument: suspend GetLocalGatewayRouteTableFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetLocalGatewayRouteTableFilterBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values
     */
    @JvmName("suuyvylcrmiwahfi")
    public suspend fun filters(vararg values: GetLocalGatewayRouteTableFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value ID of the specific local gateway route table to retrieve.
     */
    @JvmName("jrsfjkmjkijxacyq")
    public suspend fun localGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.localGatewayId = mapped
    }

    /**
     * @param value Local Gateway Route Table Id assigned to desired local gateway route table
     */
    @JvmName("lxldggrdttpyujef")
    public suspend fun localGatewayRouteTableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.localGatewayRouteTableId = mapped
    }

    /**
     * @param value ARN of the Outpost the local gateway route table is associated with.
     */
    @JvmName("ardyhmgvmsognfho")
    public suspend fun outpostArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outpostArn = mapped
    }

    /**
     * @param value State of the local gateway route table.
     */
    @JvmName("ivygknvwyiaitrvp")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.state = mapped
    }

    /**
     * @param value Mapping of tags, each pair of which must exactly match
     * a pair on the desired local gateway route table.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("jnnyqqexpaclpjyj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Mapping of tags, each pair of which must exactly match
     * a pair on the desired local gateway route table.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("eigrfahygslrgiia")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetLocalGatewayRouteTablePlainArgs = GetLocalGatewayRouteTablePlainArgs(
        filters = filters,
        localGatewayId = localGatewayId,
        localGatewayRouteTableId = localGatewayRouteTableId,
        outpostArn = outpostArn,
        state = state,
        tags = tags,
    )
}
