@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetLocalGatewayVirtualInterfaceGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLocalGatewayVirtualInterfaceGroups.
 * @property filters One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaceGroups.html) for supported filters. Detailed below.
 * @property tags Key-value map of resource tags, each pair of which must exactly match a pair on the desired local gateway route table.
 */
public data class GetLocalGatewayVirtualInterfaceGroupsPlainArgs(
    public val filters: List<GetLocalGatewayVirtualInterfaceGroupsFilter>? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetLocalGatewayVirtualInterfaceGroupsPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetLocalGatewayVirtualInterfaceGroupsPlainArgs =
        com.pulumi.aws.ec2.inputs.GetLocalGatewayVirtualInterfaceGroupsPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetLocalGatewayVirtualInterfaceGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetLocalGatewayVirtualInterfaceGroupsPlainArgsBuilder internal constructor() {
    private var filters: List<GetLocalGatewayVirtualInterfaceGroupsFilter>? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaceGroups.html) for supported filters. Detailed below.
     */
    @JvmName("ulxphpkgeslsbqic")
    public suspend fun filters(`value`: List<GetLocalGatewayVirtualInterfaceGroupsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaceGroups.html) for supported filters. Detailed below.
     */
    @JvmName("oyguxyrlhenlddis")
    public suspend
    fun filters(argument: List<suspend GetLocalGatewayVirtualInterfaceGroupsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetLocalGatewayVirtualInterfaceGroupsFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaceGroups.html) for supported filters. Detailed below.
     */
    @JvmName("aljhthgfdxnvyvfb")
    public suspend fun filters(
        vararg
        argument: suspend GetLocalGatewayVirtualInterfaceGroupsFilterBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GetLocalGatewayVirtualInterfaceGroupsFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaceGroups.html) for supported filters. Detailed below.
     */
    @JvmName("gkbmjtuurfhpuljb")
    public suspend
    fun filters(argument: suspend GetLocalGatewayVirtualInterfaceGroupsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetLocalGatewayVirtualInterfaceGroupsFilterBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaceGroups.html) for supported filters. Detailed below.
     */
    @JvmName("cgrfvdxnwpbgwmcm")
    public suspend fun filters(vararg values: GetLocalGatewayVirtualInterfaceGroupsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Key-value map of resource tags, each pair of which must exactly match a pair on the desired local gateway route table.
     */
    @JvmName("lpbeishgaoejrgju")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags, each pair of which must exactly match a pair on the desired local gateway route table.
     */
    @JvmName("tvtxekkcttamtded")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetLocalGatewayVirtualInterfaceGroupsPlainArgs =
        GetLocalGatewayVirtualInterfaceGroupsPlainArgs(
            filters = filters,
            tags = tags,
        )
}
