@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetLocalGatewaysFilter.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the field to filter by, as defined by
 * [the underlying AWS API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGateways.html).
 * @property values Set of values that are accepted for the given field.
 * A Local Gateway will be selected if any one of the given values matches.
 */
public data class GetLocalGatewaysFilter(
    public val name: String,
    public val values: List<String>,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetLocalGatewaysFilter> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetLocalGatewaysFilter =
        com.pulumi.aws.ec2.inputs.GetLocalGatewaysFilter.builder()
            .name(name.let({ args0 -> args0 }))
            .values(values.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetLocalGatewaysFilter].
 */
@PulumiTagMarker
public class GetLocalGatewaysFilterBuilder internal constructor() {
    private var name: String? = null

    private var values: List<String>? = null

    /**
     * @param value Name of the field to filter by, as defined by
     * [the underlying AWS API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGateways.html).
     */
    @JvmName("rbqjxitlfxpqddgu")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Set of values that are accepted for the given field.
     * A Local Gateway will be selected if any one of the given values matches.
     */
    @JvmName("pvvglpcmvsmnrbbi")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    /**
     * @param values Set of values that are accepted for the given field.
     * A Local Gateway will be selected if any one of the given values matches.
     */
    @JvmName("mlsrthuxltxeeeqw")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    internal fun build(): GetLocalGatewaysFilter = GetLocalGatewaysFilter(
        name = name ?: throw PulumiNullFieldException("name"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
