@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetNatGatewaysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getNatGateways.
 * @property filters Custom filter block as described below.
 * @property tags Map of tags, each pair of which must exactly match
 * a pair on the desired NAT Gateways.
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 * @property vpcId VPC ID that you want to filter from.
 */
public data class GetNatGatewaysPlainArgs(
    public val filters: List<GetNatGatewaysFilter>? = null,
    public val tags: Map<String, String>? = null,
    public val vpcId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetNatGatewaysPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetNatGatewaysPlainArgs =
        com.pulumi.aws.ec2.inputs.GetNatGatewaysPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNatGatewaysPlainArgs].
 */
@PulumiTagMarker
public class GetNatGatewaysPlainArgsBuilder internal constructor() {
    private var filters: List<GetNatGatewaysFilter>? = null

    private var tags: Map<String, String>? = null

    private var vpcId: String? = null

    /**
     * @param value Custom filter block as described below.
     */
    @JvmName("qasqblvmfneictag")
    public suspend fun filters(`value`: List<GetNatGatewaysFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("lxsixdsbyuljhrpx")
    public suspend fun filters(argument: List<suspend GetNatGatewaysFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetNatGatewaysFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("oggrabbpmibpvsdy")
    public suspend fun filters(vararg argument: suspend GetNatGatewaysFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetNatGatewaysFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("nrnlswoaaykgdhaa")
    public suspend fun filters(argument: suspend GetNatGatewaysFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetNatGatewaysFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     */
    @JvmName("shndjmvgldcpbfdx")
    public suspend fun filters(vararg values: GetNatGatewaysFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match
     * a pair on the desired NAT Gateways.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("eheguvgphucyjais")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match
     * a pair on the desired NAT Gateways.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("tiyvtneomfprjdan")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value VPC ID that you want to filter from.
     */
    @JvmName("otgohyyxqscaqkqj")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    internal fun build(): GetNatGatewaysPlainArgs = GetNatGatewaysPlainArgs(
        filters = filters,
        tags = tags,
        vpcId = vpcId,
    )
}
