@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetNetworkAclsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getNetworkAcls.
 * @property filters Custom filter block as described below.
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 * @property tags Map of tags, each pair of which must exactly match
 * a pair on the desired network ACLs.
 * @property vpcId VPC ID that you want to filter from.
 */
public data class GetNetworkAclsPlainArgs(
    public val filters: List<GetNetworkAclsFilter>? = null,
    public val tags: Map<String, String>? = null,
    public val vpcId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetNetworkAclsPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetNetworkAclsPlainArgs =
        com.pulumi.aws.ec2.inputs.GetNetworkAclsPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkAclsPlainArgs].
 */
@PulumiTagMarker
public class GetNetworkAclsPlainArgsBuilder internal constructor() {
    private var filters: List<GetNetworkAclsFilter>? = null

    private var tags: Map<String, String>? = null

    private var vpcId: String? = null

    /**
     * @param value Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("rdruuegewlsaumvq")
    public suspend fun filters(`value`: List<GetNetworkAclsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("trosnuhyphfucyhx")
    public suspend fun filters(argument: List<suspend GetNetworkAclsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetNetworkAclsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("fuoxbdstnfurovdg")
    public suspend fun filters(vararg argument: suspend GetNetworkAclsFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetNetworkAclsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("qsbisuijoyfojlut")
    public suspend fun filters(argument: suspend GetNetworkAclsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetNetworkAclsFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("aajnnfxiwupswjsp")
    public suspend fun filters(vararg values: GetNetworkAclsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match
     * a pair on the desired network ACLs.
     */
    @JvmName("bpvwepaedykvifhu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match
     * a pair on the desired network ACLs.
     */
    @JvmName("uqyesaecoknhmpnl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value VPC ID that you want to filter from.
     */
    @JvmName("mognewwvbavhsvwt")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    internal fun build(): GetNetworkAclsPlainArgs = GetNetworkAclsPlainArgs(
        filters = filters,
        tags = tags,
        vpcId = vpcId,
    )
}
