@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetNetworkInsightsAnalysisPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getNetworkInsightsAnalysis.
 * @property filters Configuration block(s) for filtering. Detailed below.
 * @property networkInsightsAnalysisId ID of the Network Insights Analysis to select.
 * @property tags
 */
public data class GetNetworkInsightsAnalysisPlainArgs(
    public val filters: List<GetNetworkInsightsAnalysisFilter>? = null,
    public val networkInsightsAnalysisId: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetNetworkInsightsAnalysisPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetNetworkInsightsAnalysisPlainArgs =
        com.pulumi.aws.ec2.inputs.GetNetworkInsightsAnalysisPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .networkInsightsAnalysisId(networkInsightsAnalysisId?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetNetworkInsightsAnalysisPlainArgs].
 */
@PulumiTagMarker
public class GetNetworkInsightsAnalysisPlainArgsBuilder internal constructor() {
    private var filters: List<GetNetworkInsightsAnalysisFilter>? = null

    private var networkInsightsAnalysisId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("mtwrfhobrnxvfdsi")
    public suspend fun filters(`value`: List<GetNetworkInsightsAnalysisFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("ryhbtcjxmmdhwhxr")
    public suspend
    fun filters(argument: List<suspend GetNetworkInsightsAnalysisFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetNetworkInsightsAnalysisFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("wtturnsdpsxmktfy")
    public suspend fun filters(
        vararg
        argument: suspend GetNetworkInsightsAnalysisFilterBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GetNetworkInsightsAnalysisFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("sulujxabbokfxkyq")
    public suspend fun filters(argument: suspend GetNetworkInsightsAnalysisFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetNetworkInsightsAnalysisFilterBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("tyyasrdmovcckofd")
    public suspend fun filters(vararg values: GetNetworkInsightsAnalysisFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value ID of the Network Insights Analysis to select.
     */
    @JvmName("pyrolnhxtlasjoic")
    public suspend fun networkInsightsAnalysisId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.networkInsightsAnalysisId = mapped
    }

    /**
     * @param value
     */
    @JvmName("koifuordfjejatii")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("nenmjuljgvmjlosh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetNetworkInsightsAnalysisPlainArgs = GetNetworkInsightsAnalysisPlainArgs(
        filters = filters,
        networkInsightsAnalysisId = networkInsightsAnalysisId,
        tags = tags,
    )
}
