@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetNetworkInterfacePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getNetworkInterface.
 * @property filters One or more name/value pairs to filter off of. There are several valid keys, for a full reference, check out [describe-network-interfaces](https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-network-interfaces.html) in the AWS CLI reference.
 * @property id Identifier for the network interface.
 * @property tags Any tags assigned to the network interface.
 */
public data class GetNetworkInterfacePlainArgs(
    public val filters: List<GetNetworkInterfaceFilter>? = null,
    public val id: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetNetworkInterfacePlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetNetworkInterfacePlainArgs =
        com.pulumi.aws.ec2.inputs.GetNetworkInterfacePlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .id(id?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetNetworkInterfacePlainArgs].
 */
@PulumiTagMarker
public class GetNetworkInterfacePlainArgsBuilder internal constructor() {
    private var filters: List<GetNetworkInterfaceFilter>? = null

    private var id: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value One or more name/value pairs to filter off of. There are several valid keys, for a full reference, check out [describe-network-interfaces](https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-network-interfaces.html) in the AWS CLI reference.
     */
    @JvmName("yxpedtdyyimcjiec")
    public suspend fun filters(`value`: List<GetNetworkInterfaceFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to filter off of. There are several valid keys, for a full reference, check out [describe-network-interfaces](https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-network-interfaces.html) in the AWS CLI reference.
     */
    @JvmName("xhdiuojdlffrxqhw")
    public suspend fun filters(argument: List<suspend GetNetworkInterfaceFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetNetworkInterfaceFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to filter off of. There are several valid keys, for a full reference, check out [describe-network-interfaces](https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-network-interfaces.html) in the AWS CLI reference.
     */
    @JvmName("sovnbsowbpklrcxh")
    public suspend fun filters(vararg argument: suspend GetNetworkInterfaceFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetNetworkInterfaceFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to filter off of. There are several valid keys, for a full reference, check out [describe-network-interfaces](https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-network-interfaces.html) in the AWS CLI reference.
     */
    @JvmName("pnfjsohjrayokelw")
    public suspend fun filters(argument: suspend GetNetworkInterfaceFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetNetworkInterfaceFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more name/value pairs to filter off of. There are several valid keys, for a full reference, check out [describe-network-interfaces](https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-network-interfaces.html) in the AWS CLI reference.
     */
    @JvmName("hmygmkrjjfddcvrd")
    public suspend fun filters(vararg values: GetNetworkInterfaceFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Identifier for the network interface.
     */
    @JvmName("xdgdlighxfwhgjoq")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Any tags assigned to the network interface.
     */
    @JvmName("fudfwguyqgcmvmak")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Any tags assigned to the network interface.
     */
    @JvmName("hybbwhcgjnnkwbnh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetNetworkInterfacePlainArgs = GetNetworkInterfacePlainArgs(
        filters = filters,
        id = id,
        tags = tags,
    )
}
