@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetNetworkInterfacesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getNetworkInterfaces.
 * @property filters Custom filter block as described below.
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 * @property tags Map of tags, each pair of which must exactly match
 * a pair on the desired network interfaces.
 */
public data class GetNetworkInterfacesPlainArgs(
    public val filters: List<GetNetworkInterfacesFilter>? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetNetworkInterfacesPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetNetworkInterfacesPlainArgs =
        com.pulumi.aws.ec2.inputs.GetNetworkInterfacesPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetNetworkInterfacesPlainArgs].
 */
@PulumiTagMarker
public class GetNetworkInterfacesPlainArgsBuilder internal constructor() {
    private var filters: List<GetNetworkInterfacesFilter>? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("cbhsigcayxtaycjn")
    public suspend fun filters(`value`: List<GetNetworkInterfacesFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("unfbokxqnlweejox")
    public suspend fun filters(argument: List<suspend GetNetworkInterfacesFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetNetworkInterfacesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("sbkqebxodhblcmot")
    public suspend fun filters(
        vararg
        argument: suspend GetNetworkInterfacesFilterBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GetNetworkInterfacesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("oywlqpgfigyjnwen")
    public suspend fun filters(argument: suspend GetNetworkInterfacesFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetNetworkInterfacesFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("vwtjiwtwvpilugqm")
    public suspend fun filters(vararg values: GetNetworkInterfacesFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match
     * a pair on the desired network interfaces.
     */
    @JvmName("vyfwnetinfticymj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match
     * a pair on the desired network interfaces.
     */
    @JvmName("jlkwnybdhcqmxhar")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetNetworkInterfacesPlainArgs = GetNetworkInterfacesPlainArgs(
        filters = filters,
        tags = tags,
    )
}
