@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetPrefixListFilter.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the filter field. Valid values can be found in the [EC2 DescribePrefixLists API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePrefixLists.html).
 * @property values Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
 */
public data class GetPrefixListFilter(
    public val name: String,
    public val values: List<String>,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetPrefixListFilter> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetPrefixListFilter =
        com.pulumi.aws.ec2.inputs.GetPrefixListFilter.builder()
            .name(name.let({ args0 -> args0 }))
            .values(values.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetPrefixListFilter].
 */
@PulumiTagMarker
public class GetPrefixListFilterBuilder internal constructor() {
    private var name: String? = null

    private var values: List<String>? = null

    /**
     * @param value Name of the filter field. Valid values can be found in the [EC2 DescribePrefixLists API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePrefixLists.html).
     */
    @JvmName("pmjrofanewoulppw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
     */
    @JvmName("xiejydmviqefrhfg")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    /**
     * @param values Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
     */
    @JvmName("hmxixwdrmwdhlrvp")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    internal fun build(): GetPrefixListFilter = GetPrefixListFilter(
        name = name ?: throw PulumiNullFieldException("name"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
