@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetPublicIpv4PoolPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPublicIpv4Pool.
 * @property poolId AWS resource IDs of a public IPv4 pool (as a string) for which this data source will fetch detailed information.
 * @property tags Any tags for the address pool.
 */
public data class GetPublicIpv4PoolPlainArgs(
    public val poolId: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetPublicIpv4PoolPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetPublicIpv4PoolPlainArgs =
        com.pulumi.aws.ec2.inputs.GetPublicIpv4PoolPlainArgs.builder()
            .poolId(poolId.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetPublicIpv4PoolPlainArgs].
 */
@PulumiTagMarker
public class GetPublicIpv4PoolPlainArgsBuilder internal constructor() {
    private var poolId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value AWS resource IDs of a public IPv4 pool (as a string) for which this data source will fetch detailed information.
     */
    @JvmName("ewoiqwqtgrqbojpy")
    public suspend fun poolId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.poolId = mapped
    }

    /**
     * @param value Any tags for the address pool.
     */
    @JvmName("wslrlywyydrctfcy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Any tags for the address pool.
     */
    @JvmName("snftgxcawowpgily")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetPublicIpv4PoolPlainArgs = GetPublicIpv4PoolPlainArgs(
        poolId = poolId ?: throw PulumiNullFieldException("poolId"),
        tags = tags,
    )
}
