@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetRoutePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRoute.
 * @property carrierGatewayId EC2 Carrier Gateway ID of the Route belonging to the Route Table.
 * @property coreNetworkArn Core network ARN of the Route belonging to the Route Table.
 * @property destinationCidrBlock CIDR block of the Route belonging to the Route Table.
 * @property destinationIpv6CidrBlock IPv6 CIDR block of the Route belonging to the Route Table.
 * @property destinationPrefixListId ID of a managed prefix list destination of the Route belonging to the Route Table.
 * @property egressOnlyGatewayId Egress Only Gateway ID of the Route belonging to the Route Table.
 * @property gatewayId Gateway ID of the Route belonging to the Route Table.
 * @property instanceId Instance ID of the Route belonging to the Route Table.
 * @property localGatewayId Local Gateway ID of the Route belonging to the Route Table.
 * @property natGatewayId NAT Gateway ID of the Route belonging to the Route Table.
 * @property networkInterfaceId Network Interface ID of the Route belonging to the Route Table.
 * @property routeTableId ID of the specific Route Table containing the Route entry.
 * The following arguments are optional:
 * @property transitGatewayId EC2 Transit Gateway ID of the Route belonging to the Route Table.
 * @property vpcPeeringConnectionId VPC Peering Connection ID of the Route belonging to the Route Table.
 */
public data class GetRoutePlainArgs(
    public val carrierGatewayId: String? = null,
    public val coreNetworkArn: String? = null,
    public val destinationCidrBlock: String? = null,
    public val destinationIpv6CidrBlock: String? = null,
    public val destinationPrefixListId: String? = null,
    public val egressOnlyGatewayId: String? = null,
    public val gatewayId: String? = null,
    public val instanceId: String? = null,
    public val localGatewayId: String? = null,
    public val natGatewayId: String? = null,
    public val networkInterfaceId: String? = null,
    public val routeTableId: String,
    public val transitGatewayId: String? = null,
    public val vpcPeeringConnectionId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetRoutePlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetRoutePlainArgs =
        com.pulumi.aws.ec2.inputs.GetRoutePlainArgs.builder()
            .carrierGatewayId(carrierGatewayId?.let({ args0 -> args0 }))
            .coreNetworkArn(coreNetworkArn?.let({ args0 -> args0 }))
            .destinationCidrBlock(destinationCidrBlock?.let({ args0 -> args0 }))
            .destinationIpv6CidrBlock(destinationIpv6CidrBlock?.let({ args0 -> args0 }))
            .destinationPrefixListId(destinationPrefixListId?.let({ args0 -> args0 }))
            .egressOnlyGatewayId(egressOnlyGatewayId?.let({ args0 -> args0 }))
            .gatewayId(gatewayId?.let({ args0 -> args0 }))
            .instanceId(instanceId?.let({ args0 -> args0 }))
            .localGatewayId(localGatewayId?.let({ args0 -> args0 }))
            .natGatewayId(natGatewayId?.let({ args0 -> args0 }))
            .networkInterfaceId(networkInterfaceId?.let({ args0 -> args0 }))
            .routeTableId(routeTableId.let({ args0 -> args0 }))
            .transitGatewayId(transitGatewayId?.let({ args0 -> args0 }))
            .vpcPeeringConnectionId(vpcPeeringConnectionId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRoutePlainArgs].
 */
@PulumiTagMarker
public class GetRoutePlainArgsBuilder internal constructor() {
    private var carrierGatewayId: String? = null

    private var coreNetworkArn: String? = null

    private var destinationCidrBlock: String? = null

    private var destinationIpv6CidrBlock: String? = null

    private var destinationPrefixListId: String? = null

    private var egressOnlyGatewayId: String? = null

    private var gatewayId: String? = null

    private var instanceId: String? = null

    private var localGatewayId: String? = null

    private var natGatewayId: String? = null

    private var networkInterfaceId: String? = null

    private var routeTableId: String? = null

    private var transitGatewayId: String? = null

    private var vpcPeeringConnectionId: String? = null

    /**
     * @param value EC2 Carrier Gateway ID of the Route belonging to the Route Table.
     */
    @JvmName("lcdnnemvwgesmhtg")
    public suspend fun carrierGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.carrierGatewayId = mapped
    }

    /**
     * @param value Core network ARN of the Route belonging to the Route Table.
     */
    @JvmName("xccsyprnoyixhbcb")
    public suspend fun coreNetworkArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.coreNetworkArn = mapped
    }

    /**
     * @param value CIDR block of the Route belonging to the Route Table.
     */
    @JvmName("ibanullhkltecofv")
    public suspend fun destinationCidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.destinationCidrBlock = mapped
    }

    /**
     * @param value IPv6 CIDR block of the Route belonging to the Route Table.
     */
    @JvmName("jrgcbbhomedksonp")
    public suspend fun destinationIpv6CidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.destinationIpv6CidrBlock = mapped
    }

    /**
     * @param value ID of a managed prefix list destination of the Route belonging to the Route Table.
     */
    @JvmName("owobgbimjytbmxhp")
    public suspend fun destinationPrefixListId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.destinationPrefixListId = mapped
    }

    /**
     * @param value Egress Only Gateway ID of the Route belonging to the Route Table.
     */
    @JvmName("heoanavbplpgnfno")
    public suspend fun egressOnlyGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.egressOnlyGatewayId = mapped
    }

    /**
     * @param value Gateway ID of the Route belonging to the Route Table.
     */
    @JvmName("uxtjosivpclbuwfv")
    public suspend fun gatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.gatewayId = mapped
    }

    /**
     * @param value Instance ID of the Route belonging to the Route Table.
     */
    @JvmName("urbgfttsngdfpugt")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value Local Gateway ID of the Route belonging to the Route Table.
     */
    @JvmName("yjwsguoaiosidsjv")
    public suspend fun localGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.localGatewayId = mapped
    }

    /**
     * @param value NAT Gateway ID of the Route belonging to the Route Table.
     */
    @JvmName("ggklrrkmktttsxqs")
    public suspend fun natGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.natGatewayId = mapped
    }

    /**
     * @param value Network Interface ID of the Route belonging to the Route Table.
     */
    @JvmName("tpelcjdcrtqkpwdi")
    public suspend fun networkInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.networkInterfaceId = mapped
    }

    /**
     * @param value ID of the specific Route Table containing the Route entry.
     * The following arguments are optional:
     */
    @JvmName("fatbmrwafncuftyo")
    public suspend fun routeTableId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.routeTableId = mapped
    }

    /**
     * @param value EC2 Transit Gateway ID of the Route belonging to the Route Table.
     */
    @JvmName("hqqyojgyhnwxqkoa")
    public suspend fun transitGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitGatewayId = mapped
    }

    /**
     * @param value VPC Peering Connection ID of the Route belonging to the Route Table.
     */
    @JvmName("tkwjmxunvysqmpdh")
    public suspend fun vpcPeeringConnectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcPeeringConnectionId = mapped
    }

    internal fun build(): GetRoutePlainArgs = GetRoutePlainArgs(
        carrierGatewayId = carrierGatewayId,
        coreNetworkArn = coreNetworkArn,
        destinationCidrBlock = destinationCidrBlock,
        destinationIpv6CidrBlock = destinationIpv6CidrBlock,
        destinationPrefixListId = destinationPrefixListId,
        egressOnlyGatewayId = egressOnlyGatewayId,
        gatewayId = gatewayId,
        instanceId = instanceId,
        localGatewayId = localGatewayId,
        natGatewayId = natGatewayId,
        networkInterfaceId = networkInterfaceId,
        routeTableId = routeTableId ?: throw PulumiNullFieldException("routeTableId"),
        transitGatewayId = transitGatewayId,
        vpcPeeringConnectionId = vpcPeeringConnectionId,
    )
}
