@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetRouteTablesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRouteTables.
 * @property filters Custom filter block as described below.
 * @property tags Map of tags, each pair of which must exactly match
 * a pair on the desired route tables.
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 * @property vpcId VPC ID that you want to filter from.
 */
public data class GetRouteTablesPlainArgs(
    public val filters: List<GetRouteTablesFilter>? = null,
    public val tags: Map<String, String>? = null,
    public val vpcId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetRouteTablesPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetRouteTablesPlainArgs =
        com.pulumi.aws.ec2.inputs.GetRouteTablesPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRouteTablesPlainArgs].
 */
@PulumiTagMarker
public class GetRouteTablesPlainArgsBuilder internal constructor() {
    private var filters: List<GetRouteTablesFilter>? = null

    private var tags: Map<String, String>? = null

    private var vpcId: String? = null

    /**
     * @param value Custom filter block as described below.
     */
    @JvmName("fwibtdyssiarwmqx")
    public suspend fun filters(`value`: List<GetRouteTablesFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("scbymupdwiixgomx")
    public suspend fun filters(argument: List<suspend GetRouteTablesFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetRouteTablesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("todlggltswsttqwv")
    public suspend fun filters(vararg argument: suspend GetRouteTablesFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetRouteTablesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("tvkkahdjpteucyix")
    public suspend fun filters(argument: suspend GetRouteTablesFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetRouteTablesFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     */
    @JvmName("dletwcbnwsbnpgpq")
    public suspend fun filters(vararg values: GetRouteTablesFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match
     * a pair on the desired route tables.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("wckgodxyllkgrcjj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match
     * a pair on the desired route tables.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("aenildxnrrqnjwwm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value VPC ID that you want to filter from.
     */
    @JvmName("fdseqhmvhhpqdwdv")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    internal fun build(): GetRouteTablesPlainArgs = GetRouteTablesPlainArgs(
        filters = filters,
        tags = tags,
        vpcId = vpcId,
    )
}
