@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetSecurityGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSecurityGroup.
 * @property filters Custom filter block as described below.
 * @property id Id of the specific security group to retrieve.
 * @property name Name of the field to filter by, as defined by
 * [the underlying AWS API](http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroups.html).
 * @property tags Map of tags, each pair of which must exactly match
 * a pair on the desired security group.
 * @property vpcId Id of the VPC that the desired security group belongs to.
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 */
public data class GetSecurityGroupPlainArgs(
    public val filters: List<GetSecurityGroupFilter>? = null,
    public val id: String? = null,
    public val name: String? = null,
    public val tags: Map<String, String>? = null,
    public val vpcId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetSecurityGroupPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetSecurityGroupPlainArgs =
        com.pulumi.aws.ec2.inputs.GetSecurityGroupPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .id(id?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSecurityGroupPlainArgs].
 */
@PulumiTagMarker
public class GetSecurityGroupPlainArgsBuilder internal constructor() {
    private var filters: List<GetSecurityGroupFilter>? = null

    private var id: String? = null

    private var name: String? = null

    private var tags: Map<String, String>? = null

    private var vpcId: String? = null

    /**
     * @param value Custom filter block as described below.
     */
    @JvmName("oekatdidrchgjyoy")
    public suspend fun filters(`value`: List<GetSecurityGroupFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("jqxhophoerrcsgay")
    public suspend fun filters(argument: List<suspend GetSecurityGroupFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetSecurityGroupFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("nqvbyuxlkabitwbm")
    public suspend fun filters(vararg argument: suspend GetSecurityGroupFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetSecurityGroupFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("vqshlvjjxwhaqpif")
    public suspend fun filters(argument: suspend GetSecurityGroupFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetSecurityGroupFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     */
    @JvmName("jxwutucwtibimxvw")
    public suspend fun filters(vararg values: GetSecurityGroupFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Id of the specific security group to retrieve.
     */
    @JvmName("dafmabpsqbbicmfh")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Name of the field to filter by, as defined by
     * [the underlying AWS API](http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroups.html).
     */
    @JvmName("vagvuowvcpiicasq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match
     * a pair on the desired security group.
     */
    @JvmName("hxrxacjmycmmnrpg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match
     * a pair on the desired security group.
     */
    @JvmName("ohibixiocfnusqid")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Id of the VPC that the desired security group belongs to.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("utjgqbufylvjkgnh")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    internal fun build(): GetSecurityGroupPlainArgs = GetSecurityGroupPlainArgs(
        filters = filters,
        id = id,
        name = name,
        tags = tags,
        vpcId = vpcId,
    )
}
