@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetSubnetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSubnet.
 * @property availabilityZone Availability zone where the subnet must reside.
 * @property availabilityZoneId ID of the Availability Zone for the subnet. This argument is not supported in all regions or partitions. If necessary, use `availability_zone` instead.
 * @property cidrBlock CIDR block of the desired subnet.
 * @property defaultForAz Whether the desired subnet must be the default subnet for its associated availability zone.
 * @property filters Configuration block. Detailed below.
 * @property id ID of the specific subnet to retrieve.
 * @property ipv6CidrBlock IPv6 CIDR block of the desired subnet.
 * @property state State that the desired subnet must have.
 * @property tags Map of tags, each pair of which must exactly match a pair on the desired subnet.
 * @property vpcId ID of the VPC that the desired subnet belongs to.
 */
public data class GetSubnetPlainArgs(
    public val availabilityZone: String? = null,
    public val availabilityZoneId: String? = null,
    public val cidrBlock: String? = null,
    public val defaultForAz: Boolean? = null,
    public val filters: List<GetSubnetFilter>? = null,
    public val id: String? = null,
    public val ipv6CidrBlock: String? = null,
    public val state: String? = null,
    public val tags: Map<String, String>? = null,
    public val vpcId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetSubnetPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetSubnetPlainArgs =
        com.pulumi.aws.ec2.inputs.GetSubnetPlainArgs.builder()
            .availabilityZone(availabilityZone?.let({ args0 -> args0 }))
            .availabilityZoneId(availabilityZoneId?.let({ args0 -> args0 }))
            .cidrBlock(cidrBlock?.let({ args0 -> args0 }))
            .defaultForAz(defaultForAz?.let({ args0 -> args0 }))
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .id(id?.let({ args0 -> args0 }))
            .ipv6CidrBlock(ipv6CidrBlock?.let({ args0 -> args0 }))
            .state(state?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSubnetPlainArgs].
 */
@PulumiTagMarker
public class GetSubnetPlainArgsBuilder internal constructor() {
    private var availabilityZone: String? = null

    private var availabilityZoneId: String? = null

    private var cidrBlock: String? = null

    private var defaultForAz: Boolean? = null

    private var filters: List<GetSubnetFilter>? = null

    private var id: String? = null

    private var ipv6CidrBlock: String? = null

    private var state: String? = null

    private var tags: Map<String, String>? = null

    private var vpcId: String? = null

    /**
     * @param value Availability zone where the subnet must reside.
     */
    @JvmName("vmsjjemrodyhyemh")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.availabilityZone = mapped
    }

    /**
     * @param value ID of the Availability Zone for the subnet. This argument is not supported in all regions or partitions. If necessary, use `availability_zone` instead.
     */
    @JvmName("rapsxkiryqyqfarc")
    public suspend fun availabilityZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.availabilityZoneId = mapped
    }

    /**
     * @param value CIDR block of the desired subnet.
     */
    @JvmName("aitmvsbfmixovndj")
    public suspend fun cidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.cidrBlock = mapped
    }

    /**
     * @param value Whether the desired subnet must be the default subnet for its associated availability zone.
     */
    @JvmName("hihekvclwbitywoy")
    public suspend fun defaultForAz(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.defaultForAz = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("uxstfiublssfnxks")
    public suspend fun filters(`value`: List<GetSubnetFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("rjbfersqsfmvmdcu")
    public suspend fun filters(argument: List<suspend GetSubnetFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { GetSubnetFilterBuilder().applySuspend { it() }.build() }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("qgslveeivrlubbne")
    public suspend fun filters(vararg argument: suspend GetSubnetFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { GetSubnetFilterBuilder().applySuspend { it() }.build() }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("ubjmmlhxayjkxkes")
    public suspend fun filters(argument: suspend GetSubnetFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetSubnetFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Configuration block. Detailed below.
     */
    @JvmName("cbyansenhsgrjadd")
    public suspend fun filters(vararg values: GetSubnetFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value ID of the specific subnet to retrieve.
     */
    @JvmName("dqqjqcnfwrbprmln")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value IPv6 CIDR block of the desired subnet.
     */
    @JvmName("fkwryssbkexbdbqk")
    public suspend fun ipv6CidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ipv6CidrBlock = mapped
    }

    /**
     * @param value State that the desired subnet must have.
     */
    @JvmName("dwbitdcdytuafnip")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.state = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match a pair on the desired subnet.
     */
    @JvmName("anxipyjjcpjoerkk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match a pair on the desired subnet.
     */
    @JvmName("nyayjawmxbghgfqp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value ID of the VPC that the desired subnet belongs to.
     */
    @JvmName("whxkdxsgntxeejbo")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    internal fun build(): GetSubnetPlainArgs = GetSubnetPlainArgs(
        availabilityZone = availabilityZone,
        availabilityZoneId = availabilityZoneId,
        cidrBlock = cidrBlock,
        defaultForAz = defaultForAz,
        filters = filters,
        id = id,
        ipv6CidrBlock = ipv6CidrBlock,
        state = state,
        tags = tags,
        vpcId = vpcId,
    )
}
