@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetTransitGatewayRouteTablesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTransitGatewayRouteTables.
 * @property filters Custom filter block as described below.
 * @property tags Mapping of tags, each pair of which must exactly match
 * a pair on the desired transit gateway route table.
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 */
public data class GetTransitGatewayRouteTablesPlainArgs(
    public val filters: List<GetTransitGatewayRouteTablesFilter>? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetTransitGatewayRouteTablesPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetTransitGatewayRouteTablesPlainArgs =
        com.pulumi.aws.ec2.inputs.GetTransitGatewayRouteTablesPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetTransitGatewayRouteTablesPlainArgs].
 */
@PulumiTagMarker
public class GetTransitGatewayRouteTablesPlainArgsBuilder internal constructor() {
    private var filters: List<GetTransitGatewayRouteTablesFilter>? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Custom filter block as described below.
     */
    @JvmName("bcpoyrredawkrrda")
    public suspend fun filters(`value`: List<GetTransitGatewayRouteTablesFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("qqbqilesbbyloejc")
    public suspend
    fun filters(argument: List<suspend GetTransitGatewayRouteTablesFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetTransitGatewayRouteTablesFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("vvlbuflxonrbpltt")
    public suspend fun filters(
        vararg
        argument: suspend GetTransitGatewayRouteTablesFilterBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GetTransitGatewayRouteTablesFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("dghgjelmfhtweesi")
    public suspend
    fun filters(argument: suspend GetTransitGatewayRouteTablesFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetTransitGatewayRouteTablesFilterBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     */
    @JvmName("ybknsewrewsftqhx")
    public suspend fun filters(vararg values: GetTransitGatewayRouteTablesFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Mapping of tags, each pair of which must exactly match
     * a pair on the desired transit gateway route table.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("cdqiabsnknwntmhe")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Mapping of tags, each pair of which must exactly match
     * a pair on the desired transit gateway route table.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("tyoieqivxnsxdern")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetTransitGatewayRouteTablesPlainArgs =
        GetTransitGatewayRouteTablesPlainArgs(
            filters = filters,
            tags = tags,
        )
}
