@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetVpcDhcpOptionsFilter.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the field to filter.
 * @property values Set of values for filtering.
 */
public data class GetVpcDhcpOptionsFilter(
    public val name: String,
    public val values: List<String>,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetVpcDhcpOptionsFilter> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetVpcDhcpOptionsFilter =
        com.pulumi.aws.ec2.inputs.GetVpcDhcpOptionsFilter.builder()
            .name(name.let({ args0 -> args0 }))
            .values(values.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetVpcDhcpOptionsFilter].
 */
@PulumiTagMarker
public class GetVpcDhcpOptionsFilterBuilder internal constructor() {
    private var name: String? = null

    private var values: List<String>? = null

    /**
     * @param value Name of the field to filter.
     */
    @JvmName("gkvuucmrmoameppd")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Set of values for filtering.
     */
    @JvmName("niehrpeoytjtvsac")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    /**
     * @param values Set of values for filtering.
     */
    @JvmName("whmxsyseqvwvltrj")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    internal fun build(): GetVpcDhcpOptionsFilter = GetVpcDhcpOptionsFilter(
        name = name ?: throw PulumiNullFieldException("name"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
