@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetVpcDhcpOptionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpcDhcpOptions.
 * @property dhcpOptionsId EC2 DHCP Options ID.
 * @property filters List of custom filters as described below.
 * @property tags Map of tags assigned to the resource.
 */
public data class GetVpcDhcpOptionsPlainArgs(
    public val dhcpOptionsId: String? = null,
    public val filters: List<GetVpcDhcpOptionsFilter>? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetVpcDhcpOptionsPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetVpcDhcpOptionsPlainArgs =
        com.pulumi.aws.ec2.inputs.GetVpcDhcpOptionsPlainArgs.builder()
            .dhcpOptionsId(dhcpOptionsId?.let({ args0 -> args0 }))
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetVpcDhcpOptionsPlainArgs].
 */
@PulumiTagMarker
public class GetVpcDhcpOptionsPlainArgsBuilder internal constructor() {
    private var dhcpOptionsId: String? = null

    private var filters: List<GetVpcDhcpOptionsFilter>? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value EC2 DHCP Options ID.
     */
    @JvmName("cwgfcxmnucmewshs")
    public suspend fun dhcpOptionsId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dhcpOptionsId = mapped
    }

    /**
     * @param value List of custom filters as described below.
     */
    @JvmName("ytnkaitjebmfpcmx")
    public suspend fun filters(`value`: List<GetVpcDhcpOptionsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument List of custom filters as described below.
     */
    @JvmName("xcyjshdapqddaxdg")
    public suspend fun filters(argument: List<suspend GetVpcDhcpOptionsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetVpcDhcpOptionsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument List of custom filters as described below.
     */
    @JvmName("vfacrhbopsqvkcdn")
    public suspend fun filters(vararg argument: suspend GetVpcDhcpOptionsFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetVpcDhcpOptionsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument List of custom filters as described below.
     */
    @JvmName("ggrgdulmsnijsptj")
    public suspend fun filters(argument: suspend GetVpcDhcpOptionsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetVpcDhcpOptionsFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values List of custom filters as described below.
     */
    @JvmName("gpcxtfpopjjaafyy")
    public suspend fun filters(vararg values: GetVpcDhcpOptionsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Map of tags assigned to the resource.
     */
    @JvmName("rgbhpyimcwnphsyv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags assigned to the resource.
     */
    @JvmName("vxkutdxgyurnggdx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetVpcDhcpOptionsPlainArgs = GetVpcDhcpOptionsPlainArgs(
        dhcpOptionsId = dhcpOptionsId,
        filters = filters,
        tags = tags,
    )
}
