@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetVpcEndpointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpcEndpoint.
 * @property filters Custom filter block as described below.
 * @property id ID of the specific VPC Endpoint to retrieve.
 * @property serviceName Service name of the specific VPC Endpoint to retrieve. For AWS services the service name is usually in the form `com.amazonaws.<region>.<service>` (the SageMaker Notebook service is an exception to this rule, the service name is in the form `aws.sagemaker.<region>.notebook`).
 * @property state State of the specific VPC Endpoint to retrieve.
 * @property tags Map of tags, each pair of which must exactly match
 * a pair on the specific VPC Endpoint to retrieve.
 * @property vpcId ID of the VPC in which the specific VPC Endpoint is used.
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 */
public data class GetVpcEndpointPlainArgs(
    public val filters: List<GetVpcEndpointFilter>? = null,
    public val id: String? = null,
    public val serviceName: String? = null,
    public val state: String? = null,
    public val tags: Map<String, String>? = null,
    public val vpcId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetVpcEndpointPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetVpcEndpointPlainArgs =
        com.pulumi.aws.ec2.inputs.GetVpcEndpointPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .id(id?.let({ args0 -> args0 }))
            .serviceName(serviceName?.let({ args0 -> args0 }))
            .state(state?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVpcEndpointPlainArgs].
 */
@PulumiTagMarker
public class GetVpcEndpointPlainArgsBuilder internal constructor() {
    private var filters: List<GetVpcEndpointFilter>? = null

    private var id: String? = null

    private var serviceName: String? = null

    private var state: String? = null

    private var tags: Map<String, String>? = null

    private var vpcId: String? = null

    /**
     * @param value Custom filter block as described below.
     */
    @JvmName("fmqmmnemlfmhkonh")
    public suspend fun filters(`value`: List<GetVpcEndpointFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("vfgswvmrpmajchmo")
    public suspend fun filters(argument: List<suspend GetVpcEndpointFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetVpcEndpointFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("dwovwbkoqekwiexl")
    public suspend fun filters(vararg argument: suspend GetVpcEndpointFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetVpcEndpointFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("gyhkuaeoinjjtmnc")
    public suspend fun filters(argument: suspend GetVpcEndpointFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetVpcEndpointFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     */
    @JvmName("mncllbwlmqglmnma")
    public suspend fun filters(vararg values: GetVpcEndpointFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value ID of the specific VPC Endpoint to retrieve.
     */
    @JvmName("oacdsoblraybkcgp")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Service name of the specific VPC Endpoint to retrieve. For AWS services the service name is usually in the form `com.amazonaws.<region>.<service>` (the SageMaker Notebook service is an exception to this rule, the service name is in the form `aws.sagemaker.<region>.notebook`).
     */
    @JvmName("bvfjupjtncyecfxp")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value State of the specific VPC Endpoint to retrieve.
     */
    @JvmName("fahpryycsbedulsf")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.state = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match
     * a pair on the specific VPC Endpoint to retrieve.
     */
    @JvmName("felqexvgbarcgpoe")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match
     * a pair on the specific VPC Endpoint to retrieve.
     */
    @JvmName("yvcmhkjdqcjlhvmw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value ID of the VPC in which the specific VPC Endpoint is used.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("fjgbouolttocqvit")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    internal fun build(): GetVpcEndpointPlainArgs = GetVpcEndpointPlainArgs(
        filters = filters,
        id = id,
        serviceName = serviceName,
        state = state,
        tags = tags,
        vpcId = vpcId,
    )
}
