@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetVpcIamPoolPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpcIamPool.
 * @property allocationResourceTags Tags that are required to create resources in using this pool.
 * @property filters Custom filter block as described below.
 * @property id ID of the IPAM pool.
 * @property ipamPoolId ID of the IPAM pool you would like information on.
 * @property tags Map of tags to assigned to the resource.
 */
public data class GetVpcIamPoolPlainArgs(
    public val allocationResourceTags: Map<String, String>? = null,
    public val filters: List<GetVpcIamPoolFilter>? = null,
    public val id: String? = null,
    public val ipamPoolId: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetVpcIamPoolPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetVpcIamPoolPlainArgs =
        com.pulumi.aws.ec2.inputs.GetVpcIamPoolPlainArgs.builder()
            .allocationResourceTags(
                allocationResourceTags?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .id(id?.let({ args0 -> args0 }))
            .ipamPoolId(ipamPoolId?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetVpcIamPoolPlainArgs].
 */
@PulumiTagMarker
public class GetVpcIamPoolPlainArgsBuilder internal constructor() {
    private var allocationResourceTags: Map<String, String>? = null

    private var filters: List<GetVpcIamPoolFilter>? = null

    private var id: String? = null

    private var ipamPoolId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Tags that are required to create resources in using this pool.
     */
    @JvmName("epdrdlpinmdkhsgp")
    public suspend fun allocationResourceTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.allocationResourceTags = mapped
    }

    /**
     * @param values Tags that are required to create resources in using this pool.
     */
    @JvmName("erqthibftubrqpva")
    public fun allocationResourceTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.allocationResourceTags = mapped
    }

    /**
     * @param value Custom filter block as described below.
     */
    @JvmName("cncvnxyprodsfmvb")
    public suspend fun filters(`value`: List<GetVpcIamPoolFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("jrdkldglkbxqishm")
    public suspend fun filters(argument: List<suspend GetVpcIamPoolFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetVpcIamPoolFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("uvybndffqwivlfrf")
    public suspend fun filters(vararg argument: suspend GetVpcIamPoolFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetVpcIamPoolFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("vfntmetbiprwjqhn")
    public suspend fun filters(argument: suspend GetVpcIamPoolFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetVpcIamPoolFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     */
    @JvmName("nigapyaedddxaplw")
    public suspend fun filters(vararg values: GetVpcIamPoolFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value ID of the IPAM pool.
     */
    @JvmName("vglambinavrfmokg")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value ID of the IPAM pool you would like information on.
     */
    @JvmName("kcpbavufywcrqqjf")
    public suspend fun ipamPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ipamPoolId = mapped
    }

    /**
     * @param value Map of tags to assigned to the resource.
     */
    @JvmName("kpvbixvapkdrynvc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assigned to the resource.
     */
    @JvmName("ioopgtemcglfvuru")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetVpcIamPoolPlainArgs = GetVpcIamPoolPlainArgs(
        allocationResourceTags = allocationResourceTags,
        filters = filters,
        id = id,
        ipamPoolId = ipamPoolId,
        tags = tags,
    )
}
