@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetVpcIpamPoolFilter.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the filter. Filter names are case-sensitive.
 * @property values The filter values. Filter values are case-sensitive.
 */
public data class GetVpcIpamPoolFilter(
    public val name: String,
    public val values: List<String>,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetVpcIpamPoolFilter> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetVpcIpamPoolFilter =
        com.pulumi.aws.ec2.inputs.GetVpcIpamPoolFilter.builder()
            .name(name.let({ args0 -> args0 }))
            .values(values.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetVpcIpamPoolFilter].
 */
@PulumiTagMarker
public class GetVpcIpamPoolFilterBuilder internal constructor() {
    private var name: String? = null

    private var values: List<String>? = null

    /**
     * @param value The name of the filter. Filter names are case-sensitive.
     */
    @JvmName("hvxptwkfmnhpgdwp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The filter values. Filter values are case-sensitive.
     */
    @JvmName("uxrvpiosasxneqrr")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    /**
     * @param values The filter values. Filter values are case-sensitive.
     */
    @JvmName("rkrsdlvekwlixxsw")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    internal fun build(): GetVpcIpamPoolFilter = GetVpcIpamPoolFilter(
        name = name ?: throw PulumiNullFieldException("name"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
