@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetVpcIpamPoolPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpcIpamPool.
 * @property allocationResourceTags Tags that are required to create resources in using this pool.
 * @property filters Custom filter block as described below.
 * @property id ID of the IPAM pool.
 * @property ipamPoolId ID of the IPAM pool you would like information on.
 * @property tags Map of tags to assigned to the resource.
 */
public data class GetVpcIpamPoolPlainArgs(
    public val allocationResourceTags: Map<String, String>? = null,
    public val filters: List<GetVpcIpamPoolFilter>? = null,
    public val id: String? = null,
    public val ipamPoolId: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetVpcIpamPoolPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetVpcIpamPoolPlainArgs =
        com.pulumi.aws.ec2.inputs.GetVpcIpamPoolPlainArgs.builder()
            .allocationResourceTags(
                allocationResourceTags?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .id(id?.let({ args0 -> args0 }))
            .ipamPoolId(ipamPoolId?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetVpcIpamPoolPlainArgs].
 */
@PulumiTagMarker
public class GetVpcIpamPoolPlainArgsBuilder internal constructor() {
    private var allocationResourceTags: Map<String, String>? = null

    private var filters: List<GetVpcIpamPoolFilter>? = null

    private var id: String? = null

    private var ipamPoolId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Tags that are required to create resources in using this pool.
     */
    @JvmName("idhtukjnrqeguiul")
    public suspend fun allocationResourceTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.allocationResourceTags = mapped
    }

    /**
     * @param values Tags that are required to create resources in using this pool.
     */
    @JvmName("clndymdtrhcboymo")
    public fun allocationResourceTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.allocationResourceTags = mapped
    }

    /**
     * @param value Custom filter block as described below.
     */
    @JvmName("rnqtfbomevmssdmw")
    public suspend fun filters(`value`: List<GetVpcIpamPoolFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("qqeuqbpnqqspccbl")
    public suspend fun filters(argument: List<suspend GetVpcIpamPoolFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetVpcIpamPoolFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("itfttvnbyudgdehe")
    public suspend fun filters(vararg argument: suspend GetVpcIpamPoolFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetVpcIpamPoolFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("whbtdwajgejwivjf")
    public suspend fun filters(argument: suspend GetVpcIpamPoolFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetVpcIpamPoolFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     */
    @JvmName("kpjsruwuqinyuyla")
    public suspend fun filters(vararg values: GetVpcIpamPoolFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value ID of the IPAM pool.
     */
    @JvmName("voeaoautuyfihrrp")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value ID of the IPAM pool you would like information on.
     */
    @JvmName("opjsiguuuhwqkcwl")
    public suspend fun ipamPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ipamPoolId = mapped
    }

    /**
     * @param value Map of tags to assigned to the resource.
     */
    @JvmName("cubqsylqcmmawmby")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assigned to the resource.
     */
    @JvmName("xssggrxsgscnaspb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetVpcIpamPoolPlainArgs = GetVpcIpamPoolPlainArgs(
        allocationResourceTags = allocationResourceTags,
        filters = filters,
        id = id,
        ipamPoolId = ipamPoolId,
        tags = tags,
    )
}
