@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetVpcPeeringConnectionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpcPeeringConnections.
 * @property filters Custom filter block as described below.
 * @property tags Mapping of tags, each pair of which must exactly match
 * a pair on the desired VPC Peering Connection.
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 */
public data class GetVpcPeeringConnectionsPlainArgs(
    public val filters: List<GetVpcPeeringConnectionsFilter>? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetVpcPeeringConnectionsPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetVpcPeeringConnectionsPlainArgs =
        com.pulumi.aws.ec2.inputs.GetVpcPeeringConnectionsPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetVpcPeeringConnectionsPlainArgs].
 */
@PulumiTagMarker
public class GetVpcPeeringConnectionsPlainArgsBuilder internal constructor() {
    private var filters: List<GetVpcPeeringConnectionsFilter>? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Custom filter block as described below.
     */
    @JvmName("qdiymairpitjhbfg")
    public suspend fun filters(`value`: List<GetVpcPeeringConnectionsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("rifydvaoxlicevvq")
    public suspend
    fun filters(argument: List<suspend GetVpcPeeringConnectionsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetVpcPeeringConnectionsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("dujirixltogowmxr")
    public suspend fun filters(
        vararg
        argument: suspend GetVpcPeeringConnectionsFilterBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GetVpcPeeringConnectionsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("ruofsslmxabmjtop")
    public suspend fun filters(argument: suspend GetVpcPeeringConnectionsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetVpcPeeringConnectionsFilterBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     */
    @JvmName("hhbdmjjqxdhpibfa")
    public suspend fun filters(vararg values: GetVpcPeeringConnectionsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Mapping of tags, each pair of which must exactly match
     * a pair on the desired VPC Peering Connection.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("yewahitfhntvcjoi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Mapping of tags, each pair of which must exactly match
     * a pair on the desired VPC Peering Connection.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("wqvvwxgrikulqhor")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetVpcPeeringConnectionsPlainArgs = GetVpcPeeringConnectionsPlainArgs(
        filters = filters,
        tags = tags,
    )
}
