@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.GetVpcPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpc.
 * @property cidrBlock Cidr block of the desired VPC.
 * @property default Boolean constraint on whether the desired VPC is
 * the default VPC for the region.
 * @property dhcpOptionsId DHCP options id of the desired VPC.
 * @property filters Custom filter block as described below.
 * @property id ID of the specific VPC to retrieve.
 * @property state Current state of the desired VPC.
 * Can be either `"pending"` or `"available"`.
 * @property tags Map of tags, each pair of which must exactly match
 * a pair on the desired VPC.
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 */
public data class GetVpcPlainArgs(
    public val cidrBlock: String? = null,
    public val default: Boolean? = null,
    public val dhcpOptionsId: String? = null,
    public val filters: List<GetVpcFilter>? = null,
    public val id: String? = null,
    public val state: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.GetVpcPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.GetVpcPlainArgs =
        com.pulumi.aws.ec2.inputs.GetVpcPlainArgs.builder()
            .cidrBlock(cidrBlock?.let({ args0 -> args0 }))
            .default_(default?.let({ args0 -> args0 }))
            .dhcpOptionsId(dhcpOptionsId?.let({ args0 -> args0 }))
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .id(id?.let({ args0 -> args0 }))
            .state(state?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetVpcPlainArgs].
 */
@PulumiTagMarker
public class GetVpcPlainArgsBuilder internal constructor() {
    private var cidrBlock: String? = null

    private var default: Boolean? = null

    private var dhcpOptionsId: String? = null

    private var filters: List<GetVpcFilter>? = null

    private var id: String? = null

    private var state: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Cidr block of the desired VPC.
     */
    @JvmName("jmtvpwpivoiwifmt")
    public suspend fun cidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.cidrBlock = mapped
    }

    /**
     * @param value Boolean constraint on whether the desired VPC is
     * the default VPC for the region.
     */
    @JvmName("rqnlxtokgieiifvt")
    public suspend fun default(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.default = mapped
    }

    /**
     * @param value DHCP options id of the desired VPC.
     */
    @JvmName("sawlrmqbtjvckjqh")
    public suspend fun dhcpOptionsId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dhcpOptionsId = mapped
    }

    /**
     * @param value Custom filter block as described below.
     */
    @JvmName("pnrtlogerflepcem")
    public suspend fun filters(`value`: List<GetVpcFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("xupcaxnqinbeeeve")
    public suspend fun filters(argument: List<suspend GetVpcFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { GetVpcFilterBuilder().applySuspend { it() }.build() }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("qxknqpveokffytje")
    public suspend fun filters(vararg argument: suspend GetVpcFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { GetVpcFilterBuilder().applySuspend { it() }.build() }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("wrqdvuflytgdsqej")
    public suspend fun filters(argument: suspend GetVpcFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetVpcFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     */
    @JvmName("qxnxvpcsxdlgyjmp")
    public suspend fun filters(vararg values: GetVpcFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value ID of the specific VPC to retrieve.
     */
    @JvmName("qqpvvkurmfwsqdnf")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Current state of the desired VPC.
     * Can be either `"pending"` or `"available"`.
     */
    @JvmName("prykriijlhyxwjxn")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.state = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match
     * a pair on the desired VPC.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("pvpewlhtkhwvuoer")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match
     * a pair on the desired VPC.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("aqqongusbhermjli")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetVpcPlainArgs = GetVpcPlainArgs(
        cidrBlock = cidrBlock,
        default = default,
        dhcpOptionsId = dhcpOptionsId,
        filters = filters,
        id = id,
        state = state,
        tags = tags,
    )
}
