@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.InstanceCapacityReservationSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property capacityReservationPreference Indicates the instance's Capacity Reservation preferences. Can be `"open"` or `"none"`. (Default: `"open"`).
 * @property capacityReservationTarget Information about the target Capacity Reservation. See Capacity Reservation Target below for more details.
 * For more information, see the documentation on [Capacity Reservations](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/capacity-reservations-using.html).
 */
public data class InstanceCapacityReservationSpecificationArgs(
    public val capacityReservationPreference: Output<String>? = null,
    public val capacityReservationTarget:
    Output<InstanceCapacityReservationSpecificationCapacityReservationTargetArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.InstanceCapacityReservationSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.InstanceCapacityReservationSpecificationArgs =
        com.pulumi.aws.ec2.inputs.InstanceCapacityReservationSpecificationArgs.builder()
            .capacityReservationPreference(capacityReservationPreference?.applyValue({ args0 -> args0 }))
            .capacityReservationTarget(
                capacityReservationTarget?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [InstanceCapacityReservationSpecificationArgs].
 */
@PulumiTagMarker
public class InstanceCapacityReservationSpecificationArgsBuilder internal constructor() {
    private var capacityReservationPreference: Output<String>? = null

    private var capacityReservationTarget:
        Output<InstanceCapacityReservationSpecificationCapacityReservationTargetArgs>? = null

    /**
     * @param value Indicates the instance's Capacity Reservation preferences. Can be `"open"` or `"none"`. (Default: `"open"`).
     */
    @JvmName("yfxayvmjmoayivpa")
    public suspend fun capacityReservationPreference(`value`: Output<String>) {
        this.capacityReservationPreference = value
    }

    /**
     * @param value Information about the target Capacity Reservation. See Capacity Reservation Target below for more details.
     * For more information, see the documentation on [Capacity Reservations](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/capacity-reservations-using.html).
     */
    @JvmName("ebqmyxtllvsxjugx")
    public suspend
    fun capacityReservationTarget(`value`: Output<InstanceCapacityReservationSpecificationCapacityReservationTargetArgs>) {
        this.capacityReservationTarget = value
    }

    /**
     * @param value Indicates the instance's Capacity Reservation preferences. Can be `"open"` or `"none"`. (Default: `"open"`).
     */
    @JvmName("vxdyyuqavilarode")
    public suspend fun capacityReservationPreference(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityReservationPreference = mapped
    }

    /**
     * @param value Information about the target Capacity Reservation. See Capacity Reservation Target below for more details.
     * For more information, see the documentation on [Capacity Reservations](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/capacity-reservations-using.html).
     */
    @JvmName("dwderlpesimettwd")
    public suspend
    fun capacityReservationTarget(`value`: InstanceCapacityReservationSpecificationCapacityReservationTargetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityReservationTarget = mapped
    }

    /**
     * @param argument Information about the target Capacity Reservation. See Capacity Reservation Target below for more details.
     * For more information, see the documentation on [Capacity Reservations](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/capacity-reservations-using.html).
     */
    @JvmName("jdiikiuqmnajcicf")
    public suspend
    fun capacityReservationTarget(argument: suspend InstanceCapacityReservationSpecificationCapacityReservationTargetArgsBuilder.() -> Unit) {
        val toBeMapped =
            InstanceCapacityReservationSpecificationCapacityReservationTargetArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.capacityReservationTarget = mapped
    }

    internal fun build(): InstanceCapacityReservationSpecificationArgs =
        InstanceCapacityReservationSpecificationArgs(
            capacityReservationPreference = capacityReservationPreference,
            capacityReservationTarget = capacityReservationTarget,
        )
}
