@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.InstanceCpuOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property amdSevSnp Indicates whether to enable the instance for AMD SEV-SNP. AMD SEV-SNP is supported with M6a, R6a, and C6a instance types only. Valid values are `enabled` and `disabled`.
 * @property coreCount Sets the number of CPU cores for an instance. This option is only supported on creation of instance type that support CPU Options [CPU Cores and Threads Per CPU Core Per Instance Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html#cpu-options-supported-instances-values) - specifying this option for unsupported instance types will return an error from the EC2 API.
 * @property threadsPerCore If set to 1, hyperthreading is disabled on the launched instance. Defaults to 2 if not set. See [Optimizing CPU Options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) for more information.
 * For more information, see the documentation on [Optimizing CPU options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html).
 */
public data class InstanceCpuOptionsArgs(
    public val amdSevSnp: Output<String>? = null,
    public val coreCount: Output<Int>? = null,
    public val threadsPerCore: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.InstanceCpuOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.InstanceCpuOptionsArgs =
        com.pulumi.aws.ec2.inputs.InstanceCpuOptionsArgs.builder()
            .amdSevSnp(amdSevSnp?.applyValue({ args0 -> args0 }))
            .coreCount(coreCount?.applyValue({ args0 -> args0 }))
            .threadsPerCore(threadsPerCore?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceCpuOptionsArgs].
 */
@PulumiTagMarker
public class InstanceCpuOptionsArgsBuilder internal constructor() {
    private var amdSevSnp: Output<String>? = null

    private var coreCount: Output<Int>? = null

    private var threadsPerCore: Output<Int>? = null

    /**
     * @param value Indicates whether to enable the instance for AMD SEV-SNP. AMD SEV-SNP is supported with M6a, R6a, and C6a instance types only. Valid values are `enabled` and `disabled`.
     */
    @JvmName("otoiyjysdxjypupj")
    public suspend fun amdSevSnp(`value`: Output<String>) {
        this.amdSevSnp = value
    }

    /**
     * @param value Sets the number of CPU cores for an instance. This option is only supported on creation of instance type that support CPU Options [CPU Cores and Threads Per CPU Core Per Instance Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html#cpu-options-supported-instances-values) - specifying this option for unsupported instance types will return an error from the EC2 API.
     */
    @JvmName("gnwbikrhpshubutc")
    public suspend fun coreCount(`value`: Output<Int>) {
        this.coreCount = value
    }

    /**
     * @param value If set to 1, hyperthreading is disabled on the launched instance. Defaults to 2 if not set. See [Optimizing CPU Options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) for more information.
     * For more information, see the documentation on [Optimizing CPU options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html).
     */
    @JvmName("knklirspifysvwel")
    public suspend fun threadsPerCore(`value`: Output<Int>) {
        this.threadsPerCore = value
    }

    /**
     * @param value Indicates whether to enable the instance for AMD SEV-SNP. AMD SEV-SNP is supported with M6a, R6a, and C6a instance types only. Valid values are `enabled` and `disabled`.
     */
    @JvmName("teopdeaoomuhujch")
    public suspend fun amdSevSnp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amdSevSnp = mapped
    }

    /**
     * @param value Sets the number of CPU cores for an instance. This option is only supported on creation of instance type that support CPU Options [CPU Cores and Threads Per CPU Core Per Instance Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html#cpu-options-supported-instances-values) - specifying this option for unsupported instance types will return an error from the EC2 API.
     */
    @JvmName("mahgvskntcwfvqyf")
    public suspend fun coreCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coreCount = mapped
    }

    /**
     * @param value If set to 1, hyperthreading is disabled on the launched instance. Defaults to 2 if not set. See [Optimizing CPU Options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) for more information.
     * For more information, see the documentation on [Optimizing CPU options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html).
     */
    @JvmName("frkrbspjljipvjuu")
    public suspend fun threadsPerCore(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threadsPerCore = mapped
    }

    internal fun build(): InstanceCpuOptionsArgs = InstanceCpuOptionsArgs(
        amdSevSnp = amdSevSnp,
        coreCount = coreCount,
        threadsPerCore = threadsPerCore,
    )
}
