@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.InstanceCreditSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cpuCredits Credit option for CPU usage. Valid values include `standard` or `unlimited`. T3 instances are launched as unlimited by default. T2 instances are launched as standard by default.
 */
public data class InstanceCreditSpecificationArgs(
    public val cpuCredits: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.InstanceCreditSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.InstanceCreditSpecificationArgs =
        com.pulumi.aws.ec2.inputs.InstanceCreditSpecificationArgs.builder()
            .cpuCredits(cpuCredits?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceCreditSpecificationArgs].
 */
@PulumiTagMarker
public class InstanceCreditSpecificationArgsBuilder internal constructor() {
    private var cpuCredits: Output<String>? = null

    /**
     * @param value Credit option for CPU usage. Valid values include `standard` or `unlimited`. T3 instances are launched as unlimited by default. T2 instances are launched as standard by default.
     */
    @JvmName("peuugpbggakdjgoq")
    public suspend fun cpuCredits(`value`: Output<String>) {
        this.cpuCredits = value
    }

    /**
     * @param value Credit option for CPU usage. Valid values include `standard` or `unlimited`. T3 instances are launched as unlimited by default. T2 instances are launched as standard by default.
     */
    @JvmName("pjtwxfaofyecdwxa")
    public suspend fun cpuCredits(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuCredits = mapped
    }

    internal fun build(): InstanceCreditSpecificationArgs = InstanceCreditSpecificationArgs(
        cpuCredits = cpuCredits,
    )
}
