@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.InstanceEphemeralBlockDeviceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deviceName Name of the block device to mount on the instance.
 * @property noDevice Suppresses the specified device included in the AMI's block device mapping.
 * @property virtualName [Instance Store Device Name](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#InstanceStoreDeviceNames) (e.g., `ephemeral0`).
 * Each AWS Instance type has a different set of Instance Store block devices available for attachment. AWS [publishes a list](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#StorageOnInstanceTypes) of which ephemeral devices are available on each type. The devices are always identified by the `virtual_name` in the format `ephemeral{0..N}`.
 */
public data class InstanceEphemeralBlockDeviceArgs(
    public val deviceName: Output<String>,
    public val noDevice: Output<Boolean>? = null,
    public val virtualName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.InstanceEphemeralBlockDeviceArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.InstanceEphemeralBlockDeviceArgs =
        com.pulumi.aws.ec2.inputs.InstanceEphemeralBlockDeviceArgs.builder()
            .deviceName(deviceName.applyValue({ args0 -> args0 }))
            .noDevice(noDevice?.applyValue({ args0 -> args0 }))
            .virtualName(virtualName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceEphemeralBlockDeviceArgs].
 */
@PulumiTagMarker
public class InstanceEphemeralBlockDeviceArgsBuilder internal constructor() {
    private var deviceName: Output<String>? = null

    private var noDevice: Output<Boolean>? = null

    private var virtualName: Output<String>? = null

    /**
     * @param value Name of the block device to mount on the instance.
     */
    @JvmName("ugnipakmagdryfaf")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value Suppresses the specified device included in the AMI's block device mapping.
     */
    @JvmName("njbiuqmrdpwtycqd")
    public suspend fun noDevice(`value`: Output<Boolean>) {
        this.noDevice = value
    }

    /**
     * @param value [Instance Store Device Name](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#InstanceStoreDeviceNames) (e.g., `ephemeral0`).
     * Each AWS Instance type has a different set of Instance Store block devices available for attachment. AWS [publishes a list](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#StorageOnInstanceTypes) of which ephemeral devices are available on each type. The devices are always identified by the `virtual_name` in the format `ephemeral{0..N}`.
     */
    @JvmName("efevjowvtkcmsxyg")
    public suspend fun virtualName(`value`: Output<String>) {
        this.virtualName = value
    }

    /**
     * @param value Name of the block device to mount on the instance.
     */
    @JvmName("oprnxoifhhcckcee")
    public suspend fun deviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value Suppresses the specified device included in the AMI's block device mapping.
     */
    @JvmName("pvwkorgeuvjwyhuf")
    public suspend fun noDevice(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noDevice = mapped
    }

    /**
     * @param value [Instance Store Device Name](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#InstanceStoreDeviceNames) (e.g., `ephemeral0`).
     * Each AWS Instance type has a different set of Instance Store block devices available for attachment. AWS [publishes a list](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#StorageOnInstanceTypes) of which ephemeral devices are available on each type. The devices are always identified by the `virtual_name` in the format `ephemeral{0..N}`.
     */
    @JvmName("elvmxdethanwwxtw")
    public suspend fun virtualName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualName = mapped
    }

    internal fun build(): InstanceEphemeralBlockDeviceArgs = InstanceEphemeralBlockDeviceArgs(
        deviceName = deviceName ?: throw PulumiNullFieldException("deviceName"),
        noDevice = noDevice,
        virtualName = virtualName,
    )
}
