@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.InstanceInstanceMarketOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property marketType Type of market for the instance. Valid value is `spot`. Defaults to `spot`.
 * @property spotOptions Block to configure the options for Spot Instances. See Spot Options below for details on attributes.
 */
public data class InstanceInstanceMarketOptionsArgs(
    public val marketType: Output<String>? = null,
    public val spotOptions: Output<InstanceInstanceMarketOptionsSpotOptionsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.InstanceInstanceMarketOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.InstanceInstanceMarketOptionsArgs =
        com.pulumi.aws.ec2.inputs.InstanceInstanceMarketOptionsArgs.builder()
            .marketType(marketType?.applyValue({ args0 -> args0 }))
            .spotOptions(spotOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [InstanceInstanceMarketOptionsArgs].
 */
@PulumiTagMarker
public class InstanceInstanceMarketOptionsArgsBuilder internal constructor() {
    private var marketType: Output<String>? = null

    private var spotOptions: Output<InstanceInstanceMarketOptionsSpotOptionsArgs>? = null

    /**
     * @param value Type of market for the instance. Valid value is `spot`. Defaults to `spot`.
     */
    @JvmName("sleteexqoiguiapf")
    public suspend fun marketType(`value`: Output<String>) {
        this.marketType = value
    }

    /**
     * @param value Block to configure the options for Spot Instances. See Spot Options below for details on attributes.
     */
    @JvmName("ifqgtammajhjproy")
    public suspend fun spotOptions(`value`: Output<InstanceInstanceMarketOptionsSpotOptionsArgs>) {
        this.spotOptions = value
    }

    /**
     * @param value Type of market for the instance. Valid value is `spot`. Defaults to `spot`.
     */
    @JvmName("komklbnpweysudea")
    public suspend fun marketType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.marketType = mapped
    }

    /**
     * @param value Block to configure the options for Spot Instances. See Spot Options below for details on attributes.
     */
    @JvmName("gslrhtqdbewjbxko")
    public suspend fun spotOptions(`value`: InstanceInstanceMarketOptionsSpotOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotOptions = mapped
    }

    /**
     * @param argument Block to configure the options for Spot Instances. See Spot Options below for details on attributes.
     */
    @JvmName("daduukjtdkdjnqgr")
    public suspend
    fun spotOptions(argument: suspend InstanceInstanceMarketOptionsSpotOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceInstanceMarketOptionsSpotOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.spotOptions = mapped
    }

    internal fun build(): InstanceInstanceMarketOptionsArgs = InstanceInstanceMarketOptionsArgs(
        marketType = marketType,
        spotOptions = spotOptions,
    )
}
