@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.LaunchTemplateElasticGpuSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type The [Elastic GPU Type](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-gpus.html#elastic-gpus-basics)
 */
public data class LaunchTemplateElasticGpuSpecificationArgs(
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.LaunchTemplateElasticGpuSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.LaunchTemplateElasticGpuSpecificationArgs =
        com.pulumi.aws.ec2.inputs.LaunchTemplateElasticGpuSpecificationArgs.builder()
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaunchTemplateElasticGpuSpecificationArgs].
 */
@PulumiTagMarker
public class LaunchTemplateElasticGpuSpecificationArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    /**
     * @param value The [Elastic GPU Type](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-gpus.html#elastic-gpus-basics)
     */
    @JvmName("ubdhrdsoyjoymqdc")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The [Elastic GPU Type](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-gpus.html#elastic-gpus-basics)
     */
    @JvmName("xppmivornrloxnml")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): LaunchTemplateElasticGpuSpecificationArgs =
        LaunchTemplateElasticGpuSpecificationArgs(
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
